"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCommandGetUserPassword = getCommandGetUserPassword;
exports.parsePasswordResponse = parsePasswordResponse;
exports.getUserPassword = getUserPassword;
const logger_1 = require("../logger");
const getDomain_1 = require("./getDomain");
const esl_1 = require("../esl");
function getCommandGetUserPassword(user, domain = 'rocket.chat') {
    return `user_data ${user}@${domain} param password`;
}
function parsePasswordResponse(response) {
    const { _body: password } = response;
    if (password === undefined) {
        logger_1.logger.error({ msg: 'Failed to load user password', response });
        throw new Error('Failed to load user password from FreeSwitch.');
    }
    return password;
}
async function getUserPassword(options, user) {
    return esl_1.FreeSwitchApiClient.runCallback(options, async (runCommand) => {
        const domainResponse = await runCommand((0, getDomain_1.getCommandGetDomain)());
        const domain = (0, getDomain_1.parseDomainResponse)(domainResponse);
        const response = await runCommand(getCommandGetUserPassword(user, domain));
        return parsePasswordResponse(response);
    });
}
//# sourceMappingURL=getUserPassword.js.map