"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCommandListFilteredUser = getCommandListFilteredUser;
exports.getExtensionDetails = getExtensionDetails;
const esl_1 = require("../esl");
const mapUserData_1 = require("../utils/mapUserData");
const parseUserList_1 = require("../utils/parseUserList");
function getCommandListFilteredUser(user, group = 'default') {
    return `list_users group ${group} user ${user}`;
}
async function getExtensionDetails(options, requestParams) {
    const { extension, group } = requestParams;
    const response = await esl_1.FreeSwitchApiClient.runSingleCommand(options, getCommandListFilteredUser(extension, group));
    const users = (0, parseUserList_1.parseUserList)(response);
    if (!users.length) {
        throw new Error('Extension not found.');
    }
    if (users.length >= 2) {
        throw new Error('Multiple extensions were found.');
    }
    return (0, mapUserData_1.mapUserData)(users[0]);
}
//# sourceMappingURL=getExtensionDetails.js.map