"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.room = room;
const core_services_1 = require("@rocket.chat/core-services");
const federation_sdk_1 = require("@rocket.chat/federation-sdk");
const models_1 = require("@rocket.chat/models");
const FederationMatrix_1 = require("../FederationMatrix");
function room(emitter) {
    emitter.on('homeserver.matrix.room.name', async ({ event }) => {
        const { room_id: roomId, content: { name }, sender: userId, } = event;
        const localRoomId = await models_1.Rooms.findOne({ 'federation.mrid': roomId }, { projection: { _id: 1 } });
        if (!localRoomId) {
            throw new Error('mapped room not found');
        }
        const localUserId = await models_1.Users.findOneByUsername(userId, { projection: { _id: 1 } });
        if (!localUserId) {
            throw new Error('mapped user not found');
        }
        await core_services_1.Room.saveRoomName(localRoomId._id, localUserId._id, name);
    });
    emitter.on('homeserver.matrix.room.topic', async ({ event }) => {
        const { room_id: roomId, content: { topic }, sender: userId, } = event;
        const localRoomId = await models_1.Rooms.findOne({ 'federation.mrid': roomId }, { projection: { _id: 1 } });
        if (!localRoomId) {
            throw new Error('mapped room not found');
        }
        const localUser = await models_1.Users.findOneByUsername(userId, { projection: { _id: 1, federation: 1, federated: 1 } });
        if (!localUser) {
            throw new Error('mapped user not found');
        }
        await core_services_1.Room.saveRoomTopic(localRoomId._id, topic, {
            _id: localUser._id,
            username: userId,
            federation: localUser.federation,
            federated: localUser.federated,
        });
    });
    emitter.on('homeserver.matrix.room.role', async (data) => {
        const { room_id: roomId, user_id: userId, sender_id: senderId, role } = data;
        const localRoomId = await models_1.Rooms.findOne({ 'federation.mrid': roomId }, { projection: { _id: 1 } });
        if (!localRoomId) {
            throw new Error('mapped room not found');
        }
        const serverName = federation_sdk_1.federationSDK.getConfig('serverName');
        const [allegedUsernameLocal, , allegedUserLocalIsLocal] = (0, FederationMatrix_1.getUsernameServername)(userId, serverName);
        const localUserId = allegedUserLocalIsLocal && (await models_1.Users.findOneByUsername(allegedUsernameLocal, { projection: { _id: 1 } }));
        if (!allegedUserLocalIsLocal) {
            return;
        }
        if (!localUserId) {
            throw new Error('mapped user not found');
        }
        const [senderUsername, , senderIsLocal] = (0, FederationMatrix_1.getUsernameServername)(senderId, serverName);
        if (senderIsLocal) {
            return;
        }
        const localSenderId = await models_1.Users.findOneByUsername(senderUsername, { projection: { _id: 1 } });
        if (!localSenderId) {
            throw new Error('mapped user not found');
        }
        await core_services_1.Room.addUserRoleRoomScoped(localSenderId._id, localUserId._id, localRoomId._id, role);
    });
}
//# sourceMappingURL=room.js.map