"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getFederationRoutes = void 0;
const http_router_1 = require("@rocket.chat/http-router");
const server_1 = require("./.well-known/server");
const invite_1 = require("./_matrix/invite");
const server_2 = require("./_matrix/key/server");
const media_1 = require("./_matrix/media");
const profiles_1 = require("./_matrix/profiles");
const rooms_1 = require("./_matrix/rooms");
const send_join_1 = require("./_matrix/send-join");
const transactions_1 = require("./_matrix/transactions");
const versions_1 = require("./_matrix/versions");
const isFederationDomainAllowed_1 = require("./middlewares/isFederationDomainAllowed");
const isFederationEnabled_1 = require("./middlewares/isFederationEnabled");
const isLicenseEnabled_1 = require("./middlewares/isLicenseEnabled");
const getFederationRoutes = () => {
    const matrix = new http_router_1.Router('/_matrix');
    const wellKnown = new http_router_1.Router('/.well-known');
    matrix
        .use(isFederationEnabled_1.isFederationEnabledMiddleware)
        .use(isLicenseEnabled_1.isLicenseEnabledMiddleware)
        .use((0, server_2.getKeyServerRoutes)())
        .use((0, versions_1.getFederationVersionsRoutes)())
        .use(isFederationDomainAllowed_1.isFederationDomainAllowedMiddleware)
        .use((0, invite_1.getMatrixInviteRoutes)())
        .use((0, profiles_1.getMatrixProfilesRoutes)())
        .use((0, rooms_1.getMatrixRoomsRoutes)())
        .use((0, send_join_1.getMatrixSendJoinRoutes)())
        .use((0, transactions_1.getMatrixTransactionsRoutes)())
        .use((0, media_1.getMatrixMediaRoutes)());
    wellKnown.use(isFederationEnabled_1.isFederationEnabledMiddleware).use(isLicenseEnabled_1.isLicenseEnabledMiddleware).use((0, server_1.getWellKnownRoutes)());
    return { matrix, wellKnown };
};
exports.getFederationRoutes = getFederationRoutes;
//# sourceMappingURL=routes.js.map