"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isLicenseEnabledMiddleware = void 0;
const core_services_1 = require("@rocket.chat/core-services");
const factory_1 = require("hono/factory");
exports.isLicenseEnabledMiddleware = (0, factory_1.createMiddleware)(async (c, next) => {
    if (!(await core_services_1.License.hasModule('federation'))) {
        return c.json({ error: 'Federation is not enabled' }, 403);
    }
    return next();
});
//# sourceMappingURL=isLicenseEnabled.js.map