"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isFederationEnabledMiddleware = void 0;
const core_services_1 = require("@rocket.chat/core-services");
const factory_1 = require("hono/factory");
exports.isFederationEnabledMiddleware = (0, factory_1.createMiddleware)(async (c, next) => {
    // TODO use federationSDK to check if federation is enabled
    if (!(await core_services_1.Settings.get('Federation_Service_Enabled'))) {
        return c.json({ error: 'Federation is not enabled' }, 403);
    }
    return next();
});
//# sourceMappingURL=isFederationEnabled.js.map