"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.isFederationDomainAllowedMiddleware = void 0;
const core_services_1 = require("@rocket.chat/core-services");
const factory_1 = require("hono/factory");
const mem_1 = __importDefault(require("mem"));
// cache for 60 seconds
const getAllowList = (0, mem_1.default)(async () => {
    const allowListSetting = await core_services_1.Settings.get('Federation_Service_Allow_List');
    return allowListSetting
        ? allowListSetting
            .split(',')
            .map((d) => d.trim().toLowerCase())
            .filter(Boolean)
        : null;
}, { maxAge: 60000 });
/**
 * Parses all key-value pairs from a Matrix authorization header.
 * Example: X-Matrix origin="matrix.org", key="value", ...
 * Returns an object with all parsed values.
 */
// TODO make this function more of a utility if needed elsewhere
function parseMatrixAuthorizationHeader(header) {
    const result = {};
    // Match key="value" pairs
    const regex = /([a-zA-Z0-9_-]+)\s*=\s*"([^"]*)"/g;
    let match;
    while ((match = regex.exec(header)) !== null) {
        result[match[1]] = match[2];
    }
    return result;
}
exports.isFederationDomainAllowedMiddleware = (0, factory_1.createMiddleware)(async (c, next) => {
    const allowList = await getAllowList();
    if (!allowList || allowList.length === 0) {
        // No restriction, allow all
        return next();
    }
    // Extract all key-value pairs from Matrix authorization header
    const authHeader = c.req.header('authorization');
    if (!authHeader) {
        return c.json({ errcode: 'M_UNAUTHORIZED', error: 'Missing Authorization headers.' }, 401);
    }
    const authValues = parseMatrixAuthorizationHeader(authHeader);
    const domain = authValues.origin?.toLowerCase();
    if (!domain) {
        return c.json({ errcode: 'M_MISSING_ORIGIN', error: 'Missing origin in authorization header.' }, 401);
    }
    // Check if domain is in allowed list
    if (allowList.some((allowed) => domain.endsWith(allowed))) {
        return next();
    }
    return c.json({ errcode: 'M_FORBIDDEN', error: 'Federation from this domain is not allowed.' }, 403);
});
//# sourceMappingURL=isFederationDomainAllowed.js.map