"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getKeyServerRoutes = void 0;
const federation_sdk_1 = require("@rocket.chat/federation-sdk");
const http_router_1 = require("@rocket.chat/http-router");
const Ajv_1 = require("@rocket.chat/rest-typings/dist/v1/Ajv");
const ServerKeyResponseSchema = {
    type: 'object',
    properties: {
        old_verify_keys: {
            type: 'object',
            description: 'Old verification keys',
        },
        server_name: {
            type: 'string',
            description: 'Matrix server name',
        },
        signatures: {
            type: 'object',
            description: 'Server signatures',
        },
        valid_until_ts: {
            type: 'number',
            minimum: 0,
            description: 'Unix timestamp in milliseconds',
        },
        verify_keys: {
            type: 'object',
            description: 'Current verification keys',
        },
    },
    required: ['old_verify_keys', 'server_name', 'signatures', 'valid_until_ts', 'verify_keys'],
};
const isServerKeyResponseProps = Ajv_1.ajv.compile(ServerKeyResponseSchema);
const getKeyServerRoutes = () => {
    return new http_router_1.Router('/key').get('/v2/server', {
        response: {
            200: isServerKeyResponseProps,
        },
        tags: ['Key'],
        license: ['federation'],
    }, async () => {
        const response = await federation_sdk_1.federationSDK.getSignedServerKey();
        return {
            body: response,
            statusCode: 200,
        };
    });
};
exports.getKeyServerRoutes = getKeyServerRoutes;
//# sourceMappingURL=server.js.map