"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmptyRuntime = void 0;
const events_1 = require("events");
const AppStatus_1 = require("../../definition/AppStatus");
class EmptyRuntime extends events_1.EventEmitter {
    constructor(appId) {
        super();
        this.appId = appId;
    }
    /**
     * Returns a disabled status since this is an empty runtime
     */
    getStatus() {
        return __awaiter(this, void 0, void 0, function* () {
            return Promise.resolve(AppStatus_1.AppStatus.COMPILER_ERROR_DISABLED);
        });
    }
    /**
     * Stub implementation that throws an error since this runtime cannot handle requests
     */
    sendRequest(message, options) {
        return __awaiter(this, void 0, void 0, function* () {
            throw new Error(`EmptyRuntime cannot handle requests. Method: ${message.method}`);
        });
    }
    /**
     * Stub implementation for setting up the runtime
     */
    setupApp() {
        return __awaiter(this, void 0, void 0, function* () {
            // Nothing to setup in an empty runtime
            return Promise.resolve();
        });
    }
    /**
     * Stub implementation for stopping the runtime
     */
    stopApp() {
        return __awaiter(this, void 0, void 0, function* () {
            // Nothing to stop in an empty runtime
            return Promise.resolve();
        });
    }
    /**
     * Get the app ID associated with this runtime
     */
    getAppId() {
        return this.appId;
    }
}
exports.EmptyRuntime = EmptyRuntime;
//# sourceMappingURL=EmptyRuntime.js.map