"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UIActionButtonManager = void 0;
const AppStatus_1 = require("../../definition/AppStatus");
const AppPermissionManager_1 = require("./AppPermissionManager");
const PermissionDeniedError_1 = require("../errors/PermissionDeniedError");
const AppPermissions_1 = require("../permissions/AppPermissions");
class UIActionButtonManager {
    constructor(manager) {
        this.registeredActionButtons = new Map();
        this.manager = manager;
        this.activationBridge = manager.getBridges().getAppActivationBridge();
    }
    registerActionButton(appId, button) {
        if (!this.hasPermission(appId)) {
            return false;
        }
        if (!this.registeredActionButtons.has(appId)) {
            this.registeredActionButtons.set(appId, new Map());
        }
        this.registeredActionButtons.get(appId).set(button.actionId, button);
        this.activationBridge.doActionsChanged();
        return true;
    }
    clearAppActionButtons(appId) {
        this.registeredActionButtons.set(appId, new Map());
        this.activationBridge.doActionsChanged();
    }
    getAppActionButtons(appId) {
        return this.registeredActionButtons.get(appId);
    }
    getAllActionButtons() {
        return __awaiter(this, void 0, void 0, function* () {
            const buttonList = [];
            // Flatten map to a simple list of buttons from enabled apps only
            for (const [appId, appButtons] of this.registeredActionButtons) {
                const app = this.manager.getOneById(appId);
                // Skip if app doesn't exist
                if (!app) {
                    continue;
                }
                // or if it is not enabled
                try {
                    const appStatus = yield app.getStatus();
                    if (!AppStatus_1.AppStatusUtils.isEnabled(appStatus)) {
                        continue;
                    }
                }
                catch (error) {
                    // If we can't get the app status, skip this app's buttons
                    continue;
                }
                // Add buttons from this enabled app
                appButtons.forEach((button) => buttonList.push(Object.assign(Object.assign({}, button), { appId })));
            }
            return buttonList;
        });
    }
    hasPermission(appId) {
        if (AppPermissionManager_1.AppPermissionManager.hasPermission(appId, AppPermissions_1.AppPermissions.ui.registerButtons)) {
            return true;
        }
        AppPermissionManager_1.AppPermissionManager.notifyAboutError(new PermissionDeniedError_1.PermissionDeniedError({
            appId,
            missingPermissions: [AppPermissions_1.AppPermissions.ui.registerButtons],
        }));
        return false;
    }
}
exports.UIActionButtonManager = UIActionButtonManager;
//# sourceMappingURL=UIActionButtonManager.js.map