"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __asyncValues = (this && this.__asyncValues) || function (o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppOutboundCommunicationProviderManager = void 0;
const AppOutboundCommunicationProvider_1 = require("./AppOutboundCommunicationProvider");
const AppPermissionManager_1 = require("./AppPermissionManager");
const PermissionDeniedError_1 = require("../errors/PermissionDeniedError");
const AppPermissions_1 = require("../permissions/AppPermissions");
class AppOutboundCommunicationProviderManager {
    constructor(manager) {
        this.manager = manager;
        this.bridge = this.manager.getBridges().getOutboundMessageBridge();
        this.accessors = this.manager.getAccessorManager();
        this.outboundMessageProviders = new Map();
    }
    isAlreadyDefined(providerId, providerType) {
        const providersByApp = this.outboundMessageProviders.get(providerId);
        if (!providersByApp) {
            return false;
        }
        if (!providersByApp.get(providerType)) {
            return false;
        }
        return true;
    }
    addProvider(appId, provider) {
        const app = this.manager.getOneById(appId);
        if (!app) {
            throw new Error('App must exist in order for an outbound provider to be added.');
        }
        if (!AppPermissionManager_1.AppPermissionManager.hasPermission(appId, AppPermissions_1.AppPermissions.outboundComms.provide)) {
            throw new PermissionDeniedError_1.PermissionDeniedError({
                appId,
                missingPermissions: [AppPermissions_1.AppPermissions.outboundComms.provide],
            });
        }
        if (!this.outboundMessageProviders.has(appId)) {
            this.outboundMessageProviders.set(appId, new Map());
        }
        this.outboundMessageProviders.get(appId).set(provider.type, new AppOutboundCommunicationProvider_1.OutboundMessageProvider(app, provider));
    }
    registerProviders(appId) {
        return __awaiter(this, void 0, void 0, function* () {
            var _a, e_1, _b, _c;
            if (!this.outboundMessageProviders.has(appId)) {
                return;
            }
            const appProviders = this.outboundMessageProviders.get(appId);
            if (!appProviders) {
                return;
            }
            try {
                for (var _d = true, appProviders_1 = __asyncValues(appProviders), appProviders_1_1; appProviders_1_1 = yield appProviders_1.next(), _a = appProviders_1_1.done, !_a; _d = true) {
                    _c = appProviders_1_1.value;
                    _d = false;
                    const [, providerInfo] = _c;
                    if (providerInfo.isRegistered) {
                        continue;
                    }
                    if (providerInfo.provider.type === 'phone') {
                        yield this.registerPhoneProvider(appId, providerInfo.provider);
                        providerInfo.setRegistered(true);
                    }
                    else if (providerInfo.provider.type === 'email') {
                        yield this.registerEmailProvider(appId, providerInfo.provider);
                        providerInfo.setRegistered(true);
                    }
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (!_d && !_a && (_b = appProviders_1.return)) yield _b.call(appProviders_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
        });
    }
    unregisterProviders(appId, opts) {
        return __awaiter(this, void 0, void 0, function* () {
            var _a, e_2, _b, _c;
            if (!this.outboundMessageProviders.has(appId)) {
                return;
            }
            const appProviders = this.outboundMessageProviders.get(appId);
            try {
                for (var _d = true, appProviders_2 = __asyncValues(appProviders), appProviders_2_1; appProviders_2_1 = yield appProviders_2.next(), _a = appProviders_2_1.done, !_a; _d = true) {
                    _c = appProviders_2_1.value;
                    _d = false;
                    const [, providerInfo] = _c;
                    yield this.unregisterProvider(appId, providerInfo, opts);
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (!_d && !_a && (_b = appProviders_2.return)) yield _b.call(appProviders_2);
                }
                finally { if (e_2) throw e_2.error; }
            }
            if (!(opts === null || opts === void 0 ? void 0 : opts.keepReferences)) {
                this.outboundMessageProviders.delete(appId);
            }
        });
    }
    registerPhoneProvider(appId, provider) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.bridge.doRegisterPhoneProvider(provider, appId);
        });
    }
    registerEmailProvider(appId, provider) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.bridge.doRegisterEmailProvider(provider, appId);
        });
    }
    unregisterProvider(appId, info, opts) {
        return __awaiter(this, void 0, void 0, function* () {
            var _a;
            const key = info.provider.type;
            yield this.bridge.doUnRegisterProvider(info.provider, appId);
            info.setRegistered(false);
            if (!(opts === null || opts === void 0 ? void 0 : opts.keepReferences)) {
                (_a = this.outboundMessageProviders.get(appId)) === null || _a === void 0 ? void 0 : _a.delete(key);
            }
        });
    }
    getProviderMetadata(appId, providerType) {
        var _a;
        const providerInfo = (_a = this.outboundMessageProviders.get(appId)) === null || _a === void 0 ? void 0 : _a.get(providerType);
        if (!providerInfo) {
            throw new Error('provider-not-registered');
        }
        return providerInfo.runGetProviderMetadata(this.manager.getLogStorage(), this.accessors);
    }
    sendOutboundMessage(appId, providerType, body) {
        var _a;
        const providerInfo = (_a = this.outboundMessageProviders.get(appId)) === null || _a === void 0 ? void 0 : _a.get(providerType);
        if (!providerInfo) {
            throw new Error('provider-not-registered');
        }
        return providerInfo.runSendOutboundMessage(this.manager.getLogStorage(), this.accessors, body);
    }
}
exports.AppOutboundCommunicationProviderManager = AppOutboundCommunicationProviderManager;
//# sourceMappingURL=AppOutboundCommunicationProviderManager.js.map