"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OutboundMessageProvider = void 0;
const metadata_1 = require("../../definition/metadata");
const AppOutboundProcessError_1 = require("../errors/AppOutboundProcessError");
class OutboundMessageProvider {
    constructor(app, provider) {
        this.app = app;
        this.provider = provider;
        this.isRegistered = false;
    }
    runGetProviderMetadata(logStorage, accessors) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.runTheCode(metadata_1.AppMethod._OUTBOUND_GET_PROVIDER_METADATA, logStorage, accessors, []);
        });
    }
    runSendOutboundMessage(logStorage, accessors, body) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.runTheCode(metadata_1.AppMethod._OUTBOUND_SEND_MESSAGE, logStorage, accessors, [body]);
        });
    }
    runTheCode(method, logStorage, accessors, runContextArgs) {
        return __awaiter(this, void 0, void 0, function* () {
            const provider = `${this.provider.name}-${this.provider.type}`;
            try {
                const result = yield this.app.getRuntimeController().sendRequest({
                    method: `outboundCommunication:${provider}:${method}`,
                    params: runContextArgs,
                });
                return result;
            }
            catch (e) {
                if ((e === null || e === void 0 ? void 0 : e.message) === 'error-invalid-provider') {
                    throw new Error('error-provider-not-registered');
                }
                throw new AppOutboundProcessError_1.AppOutboundProcessError(e.message, method);
            }
        });
    }
    setRegistered(registered) {
        this.isRegistered = registered;
    }
}
exports.OutboundMessageProvider = OutboundMessageProvider;
//# sourceMappingURL=AppOutboundCommunicationProvider.js.map