"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SettingUpdater = void 0;
/**
 * Implementation of ISettingUpdater that provides methods to update app settings.
 */
class SettingUpdater {
    constructor(app, manager) {
        this.app = app;
        this.manager = manager;
    }
    /**
     * Updates a single setting value
     * @param id The setting ID to update
     * @param value The new value to set
     * @returns Promise that resolves when the update is complete
     * @throws Error if the setting doesn't exist
     */
    updateValue(id, value) {
        return __awaiter(this, void 0, void 0, function* () {
            var _a;
            const appId = this.app.getID();
            const storageItem = this.app.getStorageItem();
            if (!((_a = storageItem.settings) === null || _a === void 0 ? void 0 : _a[id])) {
                throw new Error(`Setting "${id}" not found for app ${appId}`);
            }
            const setting = this.manager.getAppSetting(appId, id);
            this.manager.updateAppSetting(appId, Object.assign(Object.assign({}, setting), { updatedAt: new Date(), value }));
        });
    }
    /**
     * Updates the values for a multi-value setting by overwriting them
     * @param id The setting ID to update
     * @param values The new values to set
     * @returns Promise that resolves when the update is complete
     * @throws Error if the setting doesn't exist
     */
    updateSelectOptions(id, values) {
        return __awaiter(this, void 0, void 0, function* () {
            var _a;
            const appId = this.app.getID();
            const storageItem = this.app.getStorageItem();
            if (!((_a = storageItem.settings) === null || _a === void 0 ? void 0 : _a[id])) {
                throw new Error(`Setting "${id}" not found for app ${appId}`);
            }
            const setting = this.manager.getAppSetting(appId, id);
            // TODO: This operation completely overwrites existing values
            // which could lead to loss of selected values. Consider:
            // Adding warning logs when selected value will be removed
            this.manager.updateAppSetting(appId, Object.assign(Object.assign({}, setting), { updatedAt: new Date(), values }));
        });
    }
}
exports.SettingUpdater = SettingUpdater;
//# sourceMappingURL=SettingUpdater.js.map