"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ModifyCreator = void 0;
const ContactCreator_1 = require("./ContactCreator");
const DiscussionBuilder_1 = require("./DiscussionBuilder");
const EmailCreator_1 = require("./EmailCreator");
const LivechatCreator_1 = require("./LivechatCreator");
const LivechatMessageBuilder_1 = require("./LivechatMessageBuilder");
const MessageBuilder_1 = require("./MessageBuilder");
const RoomBuilder_1 = require("./RoomBuilder");
const UploadCreator_1 = require("./UploadCreator");
const UserBuilder_1 = require("./UserBuilder");
const VideoConferenceBuilder_1 = require("./VideoConferenceBuilder");
const metadata_1 = require("../../definition/metadata");
const rooms_1 = require("../../definition/rooms");
const uikit_1 = require("../../definition/uikit");
const UserType_1 = require("../../definition/users/UserType");
const UIHelper_1 = require("../misc/UIHelper");
class ModifyCreator {
    constructor(bridges, appId) {
        this.bridges = bridges;
        this.appId = appId;
        this.livechatCreator = new LivechatCreator_1.LivechatCreator(bridges, appId);
        this.uploadCreator = new UploadCreator_1.UploadCreator(bridges, appId);
        this.emailCreator = new EmailCreator_1.EmailCreator(bridges, appId);
        this.contactCreator = new ContactCreator_1.ContactCreator(bridges, appId);
    }
    getLivechatCreator() {
        return this.livechatCreator;
    }
    getUploadCreator() {
        return this.uploadCreator;
    }
    getEmailCreator() {
        return this.emailCreator;
    }
    getContactCreator() {
        return this.contactCreator;
    }
    /**
     * @deprecated please prefer the rocket.chat/ui-kit components
     */
    getBlockBuilder() {
        return new uikit_1.BlockBuilder(this.appId);
    }
    startMessage(data) {
        if (data) {
            delete data.id;
        }
        return new MessageBuilder_1.MessageBuilder(data);
    }
    startLivechatMessage(data) {
        if (data) {
            delete data.id;
        }
        return new LivechatMessageBuilder_1.LivechatMessageBuilder(data);
    }
    startRoom(data) {
        if (data) {
            delete data.id;
        }
        return new RoomBuilder_1.RoomBuilder(data);
    }
    startDiscussion(data) {
        if (data) {
            delete data.id;
        }
        return new DiscussionBuilder_1.DiscussionBuilder(data);
    }
    startVideoConference(data) {
        return new VideoConferenceBuilder_1.VideoConferenceBuilder(data);
    }
    startBotUser(data) {
        if (data) {
            delete data.id;
            const { roles } = data;
            if (roles === null || roles === void 0 ? void 0 : roles.length) {
                const hasRole = roles
                    .map((role) => role.toLocaleLowerCase())
                    .some((role) => role === 'admin' || role === 'owner' || role === 'moderator');
                if (hasRole) {
                    throw new Error('Invalid role assigned to the user. Should not be admin, owner or moderator.');
                }
            }
            if (!data.type) {
                data.type = UserType_1.UserType.BOT;
            }
        }
        return new UserBuilder_1.UserBuilder(data);
    }
    finish(builder) {
        switch (builder.kind) {
            case metadata_1.RocketChatAssociationModel.MESSAGE:
                return this._finishMessage(builder);
            case metadata_1.RocketChatAssociationModel.LIVECHAT_MESSAGE:
                return this._finishLivechatMessage(builder);
            case metadata_1.RocketChatAssociationModel.ROOM:
                return this._finishRoom(builder);
            case metadata_1.RocketChatAssociationModel.DISCUSSION:
                return this._finishDiscussion(builder);
            case metadata_1.RocketChatAssociationModel.VIDEO_CONFERENCE:
                return this._finishVideoConference(builder);
            case metadata_1.RocketChatAssociationModel.USER:
                return this._finishUser(builder);
            default:
                throw new Error('Invalid builder passed to the ModifyCreator.finish function.');
        }
    }
    _finishMessage(builder) {
        return __awaiter(this, void 0, void 0, function* () {
            var _a, _b;
            const result = builder.getMessage();
            delete result.id;
            if (!((_a = result.sender) === null || _a === void 0 ? void 0 : _a.id)) {
                const appUser = yield this.bridges.getUserBridge().doGetAppUser(this.appId);
                if (!appUser) {
                    throw new Error('Invalid sender assigned to the message.');
                }
                result.sender = appUser;
            }
            if ((_b = result.blocks) === null || _b === void 0 ? void 0 : _b.length) {
                result.blocks = UIHelper_1.UIHelper.assignIds(result.blocks, this.appId);
            }
            return this.bridges.getMessageBridge().doCreate(result, this.appId);
        });
    }
    _finishLivechatMessage(builder) {
        var _a;
        if (builder.getSender() && !builder.getVisitor()) {
            return this._finishMessage(builder.getMessageBuilder());
        }
        const result = builder.getMessage();
        delete result.id;
        if (!result.token && !((_a = result.visitor) === null || _a === void 0 ? void 0 : _a.token)) {
            throw new Error('Invalid visitor sending the message');
        }
        result.token = result.visitor ? result.visitor.token : result.token;
        return this.bridges.getLivechatBridge().doCreateMessage(result, this.appId);
    }
    _finishRoom(builder) {
        var _a, _b, _c;
        const result = builder.getRoom();
        delete result.id;
        if (!result.type) {
            throw new Error('Invalid type assigned to the room.');
        }
        if (result.type !== rooms_1.RoomType.LIVE_CHAT) {
            if (!((_a = result.creator) === null || _a === void 0 ? void 0 : _a.id)) {
                throw new Error('Invalid creator assigned to the room.');
            }
        }
        if (result.type !== rooms_1.RoomType.DIRECT_MESSAGE) {
            if (result.type !== rooms_1.RoomType.LIVE_CHAT) {
                if (!((_b = result.slugifiedName) === null || _b === void 0 ? void 0 : _b.trim())) {
                    throw new Error('Invalid slugifiedName assigned to the room.');
                }
            }
            if (!((_c = result.displayName) === null || _c === void 0 ? void 0 : _c.trim())) {
                throw new Error('Invalid displayName assigned to the room.');
            }
        }
        return this.bridges.getRoomBridge().doCreate(result, builder.getMembersToBeAddedUsernames(), this.appId);
    }
    _finishDiscussion(builder) {
        var _a, _b, _c, _d;
        const room = builder.getRoom();
        delete room.id;
        if (!((_a = room.creator) === null || _a === void 0 ? void 0 : _a.id)) {
            throw new Error('Invalid creator assigned to the discussion.');
        }
        if (!((_b = room.slugifiedName) === null || _b === void 0 ? void 0 : _b.trim())) {
            throw new Error('Invalid slugifiedName assigned to the discussion.');
        }
        if (!((_c = room.displayName) === null || _c === void 0 ? void 0 : _c.trim())) {
            throw new Error('Invalid displayName assigned to the discussion.');
        }
        if (!((_d = room.parentRoom) === null || _d === void 0 ? void 0 : _d.id)) {
            throw new Error('Invalid parentRoom assigned to the discussion.');
        }
        return this.bridges
            .getRoomBridge()
            .doCreateDiscussion(room, builder.getParentMessage(), builder.getReply(), builder.getMembersToBeAddedUsernames(), this.appId);
    }
    _finishVideoConference(builder) {
        var _a;
        const videoConference = builder.getVideoConference();
        if (!videoConference.createdBy) {
            throw new Error('Invalid creator assigned to the video conference.');
        }
        if (!((_a = videoConference.providerName) === null || _a === void 0 ? void 0 : _a.trim())) {
            throw new Error('Invalid provider name assigned to the video conference.');
        }
        if (!videoConference.rid) {
            throw new Error('Invalid roomId assigned to the video conference.');
        }
        return this.bridges.getVideoConferenceBridge().doCreate(videoConference, this.appId);
    }
    _finishUser(builder) {
        const user = builder.getUser();
        return this.bridges.getUserBridge().doCreate(user, this.appId);
    }
}
exports.ModifyCreator = ModifyCreator;
//# sourceMappingURL=ModifyCreator.js.map