import { v4 as uuid } from 'uuid';
export class UIHelper {
  /**
	 * Assign blockId, appId and actionId to every block/element inside the array
	 * @param blocks the blocks that will be iterated and assigned the ids
	 * @param appId the appId that will be assigned to
	 * @returns the array of block with the ids properties assigned
	 */ static assignIds(blocks, appId) {
    blocks.forEach((block)=>{
      if (!block.appId) {
        block.appId = appId;
      }
      if (!block.blockId) {
        block.blockId = uuid();
      }
      if (block.elements) {
        block.elements.forEach((element)=>{
          if (!element.actionId) {
            element.actionId = uuid();
          }
        });
      }
    });
    return blocks;
  }
}
//# sourceMappingURL=data:application/json;base64,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