import { fixBrokenSynchronousAPICalls } from './ast/mod.ts';
function hasPotentialDeprecatedUsage(source) {
  return(// potential usage of Room.usernames getter
  source.includes('.usernames') || // potential usage of LivechatRead.isOnline method
  source.includes('.isOnline(') || // potential usage of LivechatCreator.createToken method
  source.includes('.createToken('));
}
export function sanitizeDeprecatedUsage(source) {
  if (!hasPotentialDeprecatedUsage(source)) {
    return source;
  }
  return fixBrokenSynchronousAPICalls(source);
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImZpbGU6Ly8vaG9tZS9ydW5uZXIvd29yay9Sb2NrZXQuQ2hhdC9Sb2NrZXQuQ2hhdC9wYWNrYWdlcy9hcHBzLWVuZ2luZS9kZW5vLXJ1bnRpbWUvbGliL3Nhbml0aXplRGVwcmVjYXRlZFVzYWdlLnRzIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IGZpeEJyb2tlblN5bmNocm9ub3VzQVBJQ2FsbHMgfSBmcm9tICcuL2FzdC9tb2QudHMnO1xuXG5mdW5jdGlvbiBoYXNQb3RlbnRpYWxEZXByZWNhdGVkVXNhZ2Uoc291cmNlOiBzdHJpbmcpIHtcblx0cmV0dXJuIChcblx0XHQvLyBwb3RlbnRpYWwgdXNhZ2Ugb2YgUm9vbS51c2VybmFtZXMgZ2V0dGVyXG5cdFx0c291cmNlLmluY2x1ZGVzKCcudXNlcm5hbWVzJykgfHxcblx0XHQvLyBwb3RlbnRpYWwgdXNhZ2Ugb2YgTGl2ZWNoYXRSZWFkLmlzT25saW5lIG1ldGhvZFxuXHRcdHNvdXJjZS5pbmNsdWRlcygnLmlzT25saW5lKCcpIHx8XG5cdFx0Ly8gcG90ZW50aWFsIHVzYWdlIG9mIExpdmVjaGF0Q3JlYXRvci5jcmVhdGVUb2tlbiBtZXRob2Rcblx0XHRzb3VyY2UuaW5jbHVkZXMoJy5jcmVhdGVUb2tlbignKVxuXHQpO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gc2FuaXRpemVEZXByZWNhdGVkVXNhZ2Uoc291cmNlOiBzdHJpbmcpIHtcblx0aWYgKCFoYXNQb3RlbnRpYWxEZXByZWNhdGVkVXNhZ2Uoc291cmNlKSkge1xuXHRcdHJldHVybiBzb3VyY2U7XG5cdH1cblxuXHRyZXR1cm4gZml4QnJva2VuU3luY2hyb25vdXNBUElDYWxscyhzb3VyY2UpO1xufVxuIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLFNBQVMsNEJBQTRCLFFBQVEsZUFBZTtBQUU1RCxTQUFTLDRCQUE0QixNQUFjO0VBQ2xELE9BQ0MsMkNBQTJDO0VBQzNDLE9BQU8sUUFBUSxDQUFDLGlCQUNoQixrREFBa0Q7RUFDbEQsT0FBTyxRQUFRLENBQUMsaUJBQ2hCLHdEQUF3RDtFQUN4RCxPQUFPLFFBQVEsQ0FBQztBQUVsQjtBQUVBLE9BQU8sU0FBUyx3QkFBd0IsTUFBYztFQUNyRCxJQUFJLENBQUMsNEJBQTRCLFNBQVM7SUFDekMsT0FBTztFQUNSO0VBRUEsT0FBTyw2QkFBNkI7QUFDckMifQ==