const PrivateManager = Symbol('RoomPrivateManager');
export class Room {
  id;
  displayName;
  slugifiedName;
  type;
  creator;
  isDefault;
  isReadOnly;
  displaySystemMessages;
  messageCount;
  createdAt;
  updatedAt;
  lastModifiedAt;
  customFields;
  userIds;
  _USERNAMES;
  [PrivateManager];
  /**
	 * @deprecated
	 */ get usernames() {
    if (!this._USERNAMES) {
      this._USERNAMES = this[PrivateManager]?.getBridges().getInternalBridge().doGetUsernamesOfRoomById(this.id);
    }
    return this._USERNAMES || Promise.resolve([]);
  }
  set usernames(usernames) {}
  constructor(room, manager){
    Object.assign(this, room);
    Object.defineProperty(this, PrivateManager, {
      configurable: false,
      enumerable: false,
      writable: false,
      value: manager
    });
  }
  get value() {
    return {
      id: this.id,
      displayName: this.displayName,
      slugifiedName: this.slugifiedName,
      type: this.type,
      creator: this.creator,
      isDefault: this.isDefault,
      isReadOnly: this.isReadOnly,
      displaySystemMessages: this.displaySystemMessages,
      messageCount: this.messageCount,
      createdAt: this.createdAt,
      updatedAt: this.updatedAt,
      lastModifiedAt: this.lastModifiedAt,
      customFields: this.customFields,
      userIds: this.userIds
    };
  }
  async getUsernames() {
    // Get usernames
    if (!this._USERNAMES) {
      this._USERNAMES = await this[PrivateManager]?.getBridges().getInternalBridge().doGetUsernamesOfRoomById(this.id);
    }
    return this._USERNAMES || [];
  }
  toJSON() {
    return this.value;
  }
  toString() {
    return this.value;
  }
  valueOf() {
    return this.value;
  }
}
//# sourceMappingURL=data:application/json;base64,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