import { writeAll } from 'https://deno.land/std@0.216.0/io/write_all.ts';
import { Queue } from './messenger.ts';
export function collectMetrics() {
  return {
    pid: Deno.pid,
    queueSize: Queue.getCurrentSize()
  };
}
const encoder = new TextEncoder();
/**
 * Sends metrics collected from the system via stderr
 */ export async function sendMetrics() {
  const metrics = collectMetrics();
  await writeAll(Deno.stderr, encoder.encode(JSON.stringify(metrics)));
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImZpbGU6Ly8vaG9tZS9ydW5uZXIvd29yay9Sb2NrZXQuQ2hhdC9Sb2NrZXQuQ2hhdC9wYWNrYWdlcy9hcHBzLWVuZ2luZS9kZW5vLXJ1bnRpbWUvbGliL21ldHJpY3NDb2xsZWN0b3IudHMiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgd3JpdGVBbGwgfSBmcm9tICdodHRwczovL2Rlbm8ubGFuZC9zdGRAMC4yMTYuMC9pby93cml0ZV9hbGwudHMnO1xuaW1wb3J0IHsgUXVldWUgfSBmcm9tICcuL21lc3Nlbmdlci50cyc7XG5cbmV4cG9ydCBmdW5jdGlvbiBjb2xsZWN0TWV0cmljcygpIHtcblx0cmV0dXJuIHtcblx0XHRwaWQ6IERlbm8ucGlkLFxuXHRcdHF1ZXVlU2l6ZTogUXVldWUuZ2V0Q3VycmVudFNpemUoKSxcblx0fTtcbn1cblxuY29uc3QgZW5jb2RlciA9IG5ldyBUZXh0RW5jb2RlcigpO1xuXG4vKipcbiAqIFNlbmRzIG1ldHJpY3MgY29sbGVjdGVkIGZyb20gdGhlIHN5c3RlbSB2aWEgc3RkZXJyXG4gKi9cbmV4cG9ydCBhc3luYyBmdW5jdGlvbiBzZW5kTWV0cmljcygpIHtcblx0Y29uc3QgbWV0cmljcyA9IGNvbGxlY3RNZXRyaWNzKCk7XG5cblx0YXdhaXQgd3JpdGVBbGwoRGVuby5zdGRlcnIsIGVuY29kZXIuZW5jb2RlKEpTT04uc3RyaW5naWZ5KG1ldHJpY3MpKSk7XG59XG4iXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsU0FBUyxRQUFRLFFBQVEsZ0RBQWdEO0FBQ3pFLFNBQVMsS0FBSyxRQUFRLGlCQUFpQjtBQUV2QyxPQUFPLFNBQVM7RUFDZixPQUFPO0lBQ04sS0FBSyxLQUFLLEdBQUc7SUFDYixXQUFXLE1BQU0sY0FBYztFQUNoQztBQUNEO0FBRUEsTUFBTSxVQUFVLElBQUk7QUFFcEI7O0NBRUMsR0FDRCxPQUFPLGVBQWU7RUFDckIsTUFBTSxVQUFVO0VBRWhCLE1BQU0sU0FBUyxLQUFLLE1BQU0sRUFBRSxRQUFRLE1BQU0sQ0FBQyxLQUFLLFNBQVMsQ0FBQztBQUMzRCJ9