import { MessageBuilder } from './builders/MessageBuilder.ts';
import { AppObjectRegistry } from '../../AppObjectRegistry.ts';
import { require } from '../require.ts';
import { formatErrorResponse } from './formatResponseErrorHandler.ts';
const { TypingScope } = require('@rocket.chat/apps-engine/definition/accessors/INotifier.js');
export class Notifier {
  senderFn;
  constructor(senderFn){
    this.senderFn = senderFn;
  }
  async notifyUser(user, message) {
    if (!message.sender || !message.sender.id) {
      const appUser = await this.getAppUser();
      message.sender = appUser;
    }
    await this.callMessageBridge('doNotifyUser', [
      user,
      message,
      AppObjectRegistry.get('id')
    ]);
  }
  async notifyRoom(room, message) {
    if (!message.sender || !message.sender.id) {
      const appUser = await this.getAppUser();
      message.sender = appUser;
    }
    await this.callMessageBridge('doNotifyRoom', [
      room,
      message,
      AppObjectRegistry.get('id')
    ]);
  }
  async typing(options) {
    options.scope = options.scope || TypingScope.Room;
    if (!options.username) {
      const appUser = await this.getAppUser();
      options.username = appUser && appUser.name || '';
    }
    const appId = AppObjectRegistry.get('id');
    await this.callMessageBridge('doTyping', [
      {
        ...options,
        isTyping: true
      },
      appId
    ]);
    return async ()=>{
      await this.callMessageBridge('doTyping', [
        {
          ...options,
          isTyping: false
        },
        appId
      ]);
    };
  }
  getMessageBuilder() {
    return new MessageBuilder();
  }
  async callMessageBridge(method, params) {
    await this.senderFn({
      method: `bridges:getMessageBridge:${method}`,
      params
    }).catch((err)=>{
      throw formatErrorResponse(err);
    });
  }
  async getAppUser() {
    const response = await this.senderFn({
      method: 'bridges:getUserBridge:doGetAppUser',
      params: [
        AppObjectRegistry.get('id')
      ]
    }).catch((err)=>{
      throw formatErrorResponse(err);
    });
    return response.result;
  }
}
//# sourceMappingURL=data:application/json;base64,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