import { AppObjectRegistry } from '../../AppObjectRegistry.ts';
import { formatErrorResponse } from './formatResponseErrorHandler.ts';
export class Http {
  httpExtender;
  read;
  persistence;
  senderFn;
  constructor(read, persistence, httpExtender, senderFn){
    this.read = read;
    this.persistence = persistence;
    this.httpExtender = httpExtender;
    this.senderFn = senderFn;
  // this.httpExtender = new HttpExtend();
  }
  get(url, options) {
    return this._processHandler(url, 'get', options);
  }
  put(url, options) {
    return this._processHandler(url, 'put', options);
  }
  post(url, options) {
    return this._processHandler(url, 'post', options);
  }
  del(url, options) {
    return this._processHandler(url, 'delete', options);
  }
  patch(url, options) {
    return this._processHandler(url, 'patch', options);
  }
  async _processHandler(url, method, options) {
    let request = options || {};
    if (typeof request.headers === 'undefined') {
      request.headers = {};
    }
    this.httpExtender.getDefaultHeaders().forEach((value, key)=>{
      if (typeof request.headers?.[key] !== 'string') {
        request.headers[key] = value;
      }
    });
    if (typeof request.params === 'undefined') {
      request.params = {};
    }
    this.httpExtender.getDefaultParams().forEach((value, key)=>{
      if (typeof request.params?.[key] !== 'string') {
        request.params[key] = value;
      }
    });
    for (const handler of this.httpExtender.getPreRequestHandlers()){
      request = await handler.executePreHttpRequest(url, request, this.read, this.persistence);
    }
    let { result: response } = await this.senderFn({
      method: `bridges:getHttpBridge:doCall`,
      params: [
        {
          appId: AppObjectRegistry.get('id'),
          method,
          url,
          request
        }
      ]
    }).catch((error)=>{
      throw formatErrorResponse(error);
    });
    for (const handler of this.httpExtender.getPreResponseHandlers()){
      response = await handler.executePreHttpResponse(response, this.read, this.persistence);
    }
    return response;
  }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImZpbGU6Ly8vaG9tZS9ydW5uZXIvd29yay9Sb2NrZXQuQ2hhdC9Sb2NrZXQuQ2hhdC9wYWNrYWdlcy9hcHBzLWVuZ2luZS9kZW5vLXJ1bnRpbWUvbGliL2FjY2Vzc29ycy9odHRwLnRzIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB0eXBlIHsgSUh0dHAsIElIdHRwRXh0ZW5kLCBJSHR0cFJlcXVlc3QsIElIdHRwUmVzcG9uc2UgfSBmcm9tICdAcm9ja2V0LmNoYXQvYXBwcy1lbmdpbmUvZGVmaW5pdGlvbi9hY2Nlc3NvcnMvSUh0dHAudHMnO1xuaW1wb3J0IHR5cGUgeyBJUGVyc2lzdGVuY2UgfSBmcm9tICdAcm9ja2V0LmNoYXQvYXBwcy1lbmdpbmUvZGVmaW5pdGlvbi9hY2Nlc3NvcnMvSVBlcnNpc3RlbmNlLnRzJztcbmltcG9ydCB0eXBlIHsgSVJlYWQgfSBmcm9tICdAcm9ja2V0LmNoYXQvYXBwcy1lbmdpbmUvZGVmaW5pdGlvbi9hY2Nlc3NvcnMvSVJlYWQudHMnO1xuXG5pbXBvcnQgKiBhcyBNZXNzZW5nZXIgZnJvbSAnLi4vbWVzc2VuZ2VyLnRzJztcbmltcG9ydCB7IEFwcE9iamVjdFJlZ2lzdHJ5IH0gZnJvbSAnLi4vLi4vQXBwT2JqZWN0UmVnaXN0cnkudHMnO1xuaW1wb3J0IHsgZm9ybWF0RXJyb3JSZXNwb25zZSB9IGZyb20gJy4vZm9ybWF0UmVzcG9uc2VFcnJvckhhbmRsZXIudHMnO1xuXG50eXBlIFJlcXVlc3RNZXRob2QgPSAnZ2V0JyB8ICdwb3N0JyB8ICdwdXQnIHwgJ2hlYWQnIHwgJ2RlbGV0ZScgfCAncGF0Y2gnO1xuXG5leHBvcnQgY2xhc3MgSHR0cCBpbXBsZW1lbnRzIElIdHRwIHtcblx0cHJpdmF0ZSBodHRwRXh0ZW5kZXI6IElIdHRwRXh0ZW5kO1xuXHRwcml2YXRlIHJlYWQ6IElSZWFkO1xuXHRwcml2YXRlIHBlcnNpc3RlbmNlOiBJUGVyc2lzdGVuY2U7XG5cdHByaXZhdGUgc2VuZGVyRm46IHR5cGVvZiBNZXNzZW5nZXIuc2VuZFJlcXVlc3Q7XG5cblx0Y29uc3RydWN0b3IocmVhZDogSVJlYWQsIHBlcnNpc3RlbmNlOiBJUGVyc2lzdGVuY2UsIGh0dHBFeHRlbmRlcjogSUh0dHBFeHRlbmQsIHNlbmRlckZuOiB0eXBlb2YgTWVzc2VuZ2VyLnNlbmRSZXF1ZXN0KSB7XG5cdFx0dGhpcy5yZWFkID0gcmVhZDtcblx0XHR0aGlzLnBlcnNpc3RlbmNlID0gcGVyc2lzdGVuY2U7XG5cdFx0dGhpcy5odHRwRXh0ZW5kZXIgPSBodHRwRXh0ZW5kZXI7XG5cdFx0dGhpcy5zZW5kZXJGbiA9IHNlbmRlckZuO1xuXHRcdC8vIHRoaXMuaHR0cEV4dGVuZGVyID0gbmV3IEh0dHBFeHRlbmQoKTtcblx0fVxuXG5cdHB1YmxpYyBnZXQodXJsOiBzdHJpbmcsIG9wdGlvbnM/OiBJSHR0cFJlcXVlc3QpOiBQcm9taXNlPElIdHRwUmVzcG9uc2U+IHtcblx0XHRyZXR1cm4gdGhpcy5fcHJvY2Vzc0hhbmRsZXIodXJsLCAnZ2V0Jywgb3B0aW9ucyk7XG5cdH1cblxuXHRwdWJsaWMgcHV0KHVybDogc3RyaW5nLCBvcHRpb25zPzogSUh0dHBSZXF1ZXN0KTogUHJvbWlzZTxJSHR0cFJlc3BvbnNlPiB7XG5cdFx0cmV0dXJuIHRoaXMuX3Byb2Nlc3NIYW5kbGVyKHVybCwgJ3B1dCcsIG9wdGlvbnMpO1xuXHR9XG5cblx0cHVibGljIHBvc3QodXJsOiBzdHJpbmcsIG9wdGlvbnM/OiBJSHR0cFJlcXVlc3QpOiBQcm9taXNlPElIdHRwUmVzcG9uc2U+IHtcblx0XHRyZXR1cm4gdGhpcy5fcHJvY2Vzc0hhbmRsZXIodXJsLCAncG9zdCcsIG9wdGlvbnMpO1xuXHR9XG5cblx0cHVibGljIGRlbCh1cmw6IHN0cmluZywgb3B0aW9ucz86IElIdHRwUmVxdWVzdCk6IFByb21pc2U8SUh0dHBSZXNwb25zZT4ge1xuXHRcdHJldHVybiB0aGlzLl9wcm9jZXNzSGFuZGxlcih1cmwsICdkZWxldGUnLCBvcHRpb25zKTtcblx0fVxuXG5cdHB1YmxpYyBwYXRjaCh1cmw6IHN0cmluZywgb3B0aW9ucz86IElIdHRwUmVxdWVzdCk6IFByb21pc2U8SUh0dHBSZXNwb25zZT4ge1xuXHRcdHJldHVybiB0aGlzLl9wcm9jZXNzSGFuZGxlcih1cmwsICdwYXRjaCcsIG9wdGlvbnMpO1xuXHR9XG5cblx0cHJpdmF0ZSBhc3luYyBfcHJvY2Vzc0hhbmRsZXIodXJsOiBzdHJpbmcsIG1ldGhvZDogUmVxdWVzdE1ldGhvZCwgb3B0aW9ucz86IElIdHRwUmVxdWVzdCk6IFByb21pc2U8SUh0dHBSZXNwb25zZT4ge1xuXHRcdGxldCByZXF1ZXN0ID0gb3B0aW9ucyB8fCB7fTtcblxuXHRcdGlmICh0eXBlb2YgcmVxdWVzdC5oZWFkZXJzID09PSAndW5kZWZpbmVkJykge1xuXHRcdFx0cmVxdWVzdC5oZWFkZXJzID0ge307XG5cdFx0fVxuXG5cdFx0dGhpcy5odHRwRXh0ZW5kZXIuZ2V0RGVmYXVsdEhlYWRlcnMoKS5mb3JFYWNoKCh2YWx1ZTogc3RyaW5nLCBrZXk6IHN0cmluZykgPT4ge1xuXHRcdFx0aWYgKHR5cGVvZiByZXF1ZXN0LmhlYWRlcnM/LltrZXldICE9PSAnc3RyaW5nJykge1xuXHRcdFx0XHRyZXF1ZXN0LmhlYWRlcnMhW2tleV0gPSB2YWx1ZTtcblx0XHRcdH1cblx0XHR9KTtcblxuXHRcdGlmICh0eXBlb2YgcmVxdWVzdC5wYXJhbXMgPT09ICd1bmRlZmluZWQnKSB7XG5cdFx0XHRyZXF1ZXN0LnBhcmFtcyA9IHt9O1xuXHRcdH1cblxuXHRcdHRoaXMuaHR0cEV4dGVuZGVyLmdldERlZmF1bHRQYXJhbXMoKS5mb3JFYWNoKCh2YWx1ZTogc3RyaW5nLCBrZXk6IHN0cmluZykgPT4ge1xuXHRcdFx0aWYgKHR5cGVvZiByZXF1ZXN0LnBhcmFtcz8uW2tleV0gIT09ICdzdHJpbmcnKSB7XG5cdFx0XHRcdHJlcXVlc3QucGFyYW1zIVtrZXldID0gdmFsdWU7XG5cdFx0XHR9XG5cdFx0fSk7XG5cblx0XHRmb3IgKGNvbnN0IGhhbmRsZXIgb2YgdGhpcy5odHRwRXh0ZW5kZXIuZ2V0UHJlUmVxdWVzdEhhbmRsZXJzKCkpIHtcblx0XHRcdHJlcXVlc3QgPSBhd2FpdCBoYW5kbGVyLmV4ZWN1dGVQcmVIdHRwUmVxdWVzdCh1cmwsIHJlcXVlc3QsIHRoaXMucmVhZCwgdGhpcy5wZXJzaXN0ZW5jZSk7XG5cdFx0fVxuXG5cdFx0bGV0IHsgcmVzdWx0OiByZXNwb25zZSB9ID0gYXdhaXQgdGhpcy5zZW5kZXJGbih7XG5cdFx0XHRtZXRob2Q6IGBicmlkZ2VzOmdldEh0dHBCcmlkZ2U6ZG9DYWxsYCxcblx0XHRcdHBhcmFtczogW1xuXHRcdFx0XHR7XG5cdFx0XHRcdFx0YXBwSWQ6IEFwcE9iamVjdFJlZ2lzdHJ5LmdldDxzdHJpbmc+KCdpZCcpLFxuXHRcdFx0XHRcdG1ldGhvZCxcblx0XHRcdFx0XHR1cmwsXG5cdFx0XHRcdFx0cmVxdWVzdCxcblx0XHRcdFx0fSxcblx0XHRcdF0sXG5cdFx0fSkuY2F0Y2goKGVycm9yKSA9PiB7XG5cdFx0XHR0aHJvdyBmb3JtYXRFcnJvclJlc3BvbnNlKGVycm9yKTtcblx0XHR9KTtcblxuXHRcdGZvciAoY29uc3QgaGFuZGxlciBvZiB0aGlzLmh0dHBFeHRlbmRlci5nZXRQcmVSZXNwb25zZUhhbmRsZXJzKCkpIHtcblx0XHRcdHJlc3BvbnNlID0gYXdhaXQgaGFuZGxlci5leGVjdXRlUHJlSHR0cFJlc3BvbnNlKHJlc3BvbnNlIGFzIElIdHRwUmVzcG9uc2UsIHRoaXMucmVhZCwgdGhpcy5wZXJzaXN0ZW5jZSk7XG5cdFx0fVxuXG5cdFx0cmV0dXJuIHJlc3BvbnNlIGFzIElIdHRwUmVzcG9uc2U7XG5cdH1cbn1cbiJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFLQSxTQUFTLGlCQUFpQixRQUFRLDZCQUE2QjtBQUMvRCxTQUFTLG1CQUFtQixRQUFRLGtDQUFrQztBQUl0RSxPQUFPLE1BQU07RUFDSixhQUEwQjtFQUMxQixLQUFZO0VBQ1osWUFBMEI7RUFDMUIsU0FBdUM7RUFFL0MsWUFBWSxJQUFXLEVBQUUsV0FBeUIsRUFBRSxZQUF5QixFQUFFLFFBQXNDLENBQUU7SUFDdEgsSUFBSSxDQUFDLElBQUksR0FBRztJQUNaLElBQUksQ0FBQyxXQUFXLEdBQUc7SUFDbkIsSUFBSSxDQUFDLFlBQVksR0FBRztJQUNwQixJQUFJLENBQUMsUUFBUSxHQUFHO0VBQ2hCLHdDQUF3QztFQUN6QztFQUVPLElBQUksR0FBVyxFQUFFLE9BQXNCLEVBQTBCO0lBQ3ZFLE9BQU8sSUFBSSxDQUFDLGVBQWUsQ0FBQyxLQUFLLE9BQU87RUFDekM7RUFFTyxJQUFJLEdBQVcsRUFBRSxPQUFzQixFQUEwQjtJQUN2RSxPQUFPLElBQUksQ0FBQyxlQUFlLENBQUMsS0FBSyxPQUFPO0VBQ3pDO0VBRU8sS0FBSyxHQUFXLEVBQUUsT0FBc0IsRUFBMEI7SUFDeEUsT0FBTyxJQUFJLENBQUMsZUFBZSxDQUFDLEtBQUssUUFBUTtFQUMxQztFQUVPLElBQUksR0FBVyxFQUFFLE9BQXNCLEVBQTBCO0lBQ3ZFLE9BQU8sSUFBSSxDQUFDLGVBQWUsQ0FBQyxLQUFLLFVBQVU7RUFDNUM7RUFFTyxNQUFNLEdBQVcsRUFBRSxPQUFzQixFQUEwQjtJQUN6RSxPQUFPLElBQUksQ0FBQyxlQUFlLENBQUMsS0FBSyxTQUFTO0VBQzNDO0VBRUEsTUFBYyxnQkFBZ0IsR0FBVyxFQUFFLE1BQXFCLEVBQUUsT0FBc0IsRUFBMEI7SUFDakgsSUFBSSxVQUFVLFdBQVcsQ0FBQztJQUUxQixJQUFJLE9BQU8sUUFBUSxPQUFPLEtBQUssYUFBYTtNQUMzQyxRQUFRLE9BQU8sR0FBRyxDQUFDO0lBQ3BCO0lBRUEsSUFBSSxDQUFDLFlBQVksQ0FBQyxpQkFBaUIsR0FBRyxPQUFPLENBQUMsQ0FBQyxPQUFlO01BQzdELElBQUksT0FBTyxRQUFRLE9BQU8sRUFBRSxDQUFDLElBQUksS0FBSyxVQUFVO1FBQy9DLFFBQVEsT0FBTyxBQUFDLENBQUMsSUFBSSxHQUFHO01BQ3pCO0lBQ0Q7SUFFQSxJQUFJLE9BQU8sUUFBUSxNQUFNLEtBQUssYUFBYTtNQUMxQyxRQUFRLE1BQU0sR0FBRyxDQUFDO0lBQ25CO0lBRUEsSUFBSSxDQUFDLFlBQVksQ0FBQyxnQkFBZ0IsR0FBRyxPQUFPLENBQUMsQ0FBQyxPQUFlO01BQzVELElBQUksT0FBTyxRQUFRLE1BQU0sRUFBRSxDQUFDLElBQUksS0FBSyxVQUFVO1FBQzlDLFFBQVEsTUFBTSxBQUFDLENBQUMsSUFBSSxHQUFHO01BQ3hCO0lBQ0Q7SUFFQSxLQUFLLE1BQU0sV0FBVyxJQUFJLENBQUMsWUFBWSxDQUFDLHFCQUFxQixHQUFJO01BQ2hFLFVBQVUsTUFBTSxRQUFRLHFCQUFxQixDQUFDLEtBQUssU0FBUyxJQUFJLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxXQUFXO0lBQ3hGO0lBRUEsSUFBSSxFQUFFLFFBQVEsUUFBUSxFQUFFLEdBQUcsTUFBTSxJQUFJLENBQUMsUUFBUSxDQUFDO01BQzlDLFFBQVEsQ0FBQyw0QkFBNEIsQ0FBQztNQUN0QyxRQUFRO1FBQ1A7VUFDQyxPQUFPLGtCQUFrQixHQUFHLENBQVM7VUFDckM7VUFDQTtVQUNBO1FBQ0Q7T0FDQTtJQUNGLEdBQUcsS0FBSyxDQUFDLENBQUM7TUFDVCxNQUFNLG9CQUFvQjtJQUMzQjtJQUVBLEtBQUssTUFBTSxXQUFXLElBQUksQ0FBQyxZQUFZLENBQUMsc0JBQXNCLEdBQUk7TUFDakUsV0FBVyxNQUFNLFFBQVEsc0JBQXNCLENBQUMsVUFBMkIsSUFBSSxDQUFDLElBQUksRUFBRSxJQUFJLENBQUMsV0FBVztJQUN2RztJQUVBLE9BQU87RUFDUjtBQUNEIn0=