import { ErrorObject } from 'jsonrpc-lite';
// deno-lint-ignore no-explicit-any -- that is the type we get from `catch`
export const formatErrorResponse = (error)=>{
  if (error instanceof ErrorObject || typeof error?.error?.message === 'string') {
    return new Error(error.error.message);
  }
  if (error instanceof Error) {
    return error;
  }
  return new Error('An unknown error occurred', {
    cause: error
  });
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImZpbGU6Ly8vaG9tZS9ydW5uZXIvd29yay9Sb2NrZXQuQ2hhdC9Sb2NrZXQuQ2hhdC9wYWNrYWdlcy9hcHBzLWVuZ2luZS9kZW5vLXJ1bnRpbWUvbGliL2FjY2Vzc29ycy9mb3JtYXRSZXNwb25zZUVycm9ySGFuZGxlci50cyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBFcnJvck9iamVjdCB9IGZyb20gJ2pzb25ycGMtbGl0ZSc7XG5cbi8vIGRlbm8tbGludC1pZ25vcmUgbm8tZXhwbGljaXQtYW55IC0tIHRoYXQgaXMgdGhlIHR5cGUgd2UgZ2V0IGZyb20gYGNhdGNoYFxuZXhwb3J0IGNvbnN0IGZvcm1hdEVycm9yUmVzcG9uc2UgPSAoZXJyb3I6IGFueSk6IEVycm9yID0+IHtcblx0aWYgKGVycm9yIGluc3RhbmNlb2YgRXJyb3JPYmplY3QgfHwgdHlwZW9mIGVycm9yPy5lcnJvcj8ubWVzc2FnZSA9PT0gJ3N0cmluZycpIHtcblx0XHRyZXR1cm4gbmV3IEVycm9yKGVycm9yLmVycm9yLm1lc3NhZ2UpO1xuXHR9XG5cblx0aWYgKGVycm9yIGluc3RhbmNlb2YgRXJyb3IpIHtcblx0XHRyZXR1cm4gZXJyb3I7XG5cdH1cblxuXHRyZXR1cm4gbmV3IEVycm9yKCdBbiB1bmtub3duIGVycm9yIG9jY3VycmVkJywgeyBjYXVzZTogZXJyb3IgfSk7XG59O1xuIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLFNBQVMsV0FBVyxRQUFRLGVBQWU7QUFFM0MsMkVBQTJFO0FBQzNFLE9BQU8sTUFBTSxzQkFBc0IsQ0FBQztFQUNuQyxJQUFJLGlCQUFpQixlQUFlLE9BQU8sT0FBTyxPQUFPLFlBQVksVUFBVTtJQUM5RSxPQUFPLElBQUksTUFBTSxNQUFNLEtBQUssQ0FBQyxPQUFPO0VBQ3JDO0VBRUEsSUFBSSxpQkFBaUIsT0FBTztJQUMzQixPQUFPO0VBQ1I7RUFFQSxPQUFPLElBQUksTUFBTSw2QkFBNkI7SUFBRSxPQUFPO0VBQU07QUFDOUQsRUFBRSJ9