import { require } from '../../../lib/require.ts';
const { RocketChatAssociationModel } = require('@rocket.chat/apps-engine/definition/metadata/RocketChatAssociations.js');
export class VideoConferenceExtender {
  videoConference;
  kind;
  constructor(videoConference){
    this.videoConference = videoConference;
    this.kind = RocketChatAssociationModel.VIDEO_CONFERENCE;
  }
  setProviderData(value) {
    this.videoConference.providerData = value;
    return this;
  }
  setStatus(value) {
    this.videoConference.status = value;
    return this;
  }
  setEndedBy(value) {
    this.videoConference.endedBy = {
      _id: value,
      // Name and username will be loaded automatically by the bridge
      username: '',
      name: ''
    };
    return this;
  }
  setEndedAt(value) {
    this.videoConference.endedAt = value;
    return this;
  }
  addUser(userId, ts) {
    this.videoConference.users.push({
      _id: userId,
      ts,
      // Name and username will be loaded automatically by the bridge
      username: '',
      name: ''
    });
    return this;
  }
  setDiscussionRid(rid) {
    this.videoConference.discussionRid = rid;
    return this;
  }
  getVideoConference() {
    return structuredClone(this.videoConference);
  }
}
//# sourceMappingURL=data:application/json;base64,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