import { require } from '../../../lib/require.ts';
const { RocketChatAssociationModel } = require('@rocket.chat/apps-engine/definition/metadata/RocketChatAssociations.js');
export class UserBuilder {
  kind;
  user;
  constructor(user){
    this.kind = RocketChatAssociationModel.USER;
    this.user = user || {};
  }
  setData(data) {
    delete data.id;
    this.user = data;
    return this;
  }
  setEmails(emails) {
    this.user.emails = emails;
    return this;
  }
  getEmails() {
    return this.user.emails;
  }
  setDisplayName(name) {
    this.user.name = name;
    return this;
  }
  getDisplayName() {
    return this.user.name;
  }
  setUsername(username) {
    this.user.username = username;
    return this;
  }
  getUsername() {
    return this.user.username;
  }
  setRoles(roles) {
    this.user.roles = roles;
    return this;
  }
  getRoles() {
    return this.user.roles;
  }
  getSettings() {
    return this.user.settings;
  }
  getUser() {
    if (!this.user.username) {
      throw new Error('The "username" property is required.');
    }
    if (!this.user.name) {
      throw new Error('The "name" property is required.');
    }
    return this.user;
  }
}
//# sourceMappingURL=data:application/json;base64,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