import { require } from '../../../lib/require.ts';
const { RocketChatAssociationModel } = require('@rocket.chat/apps-engine/definition/metadata/RocketChatAssociations.js');
export class RoomBuilder {
  kind;
  room;
  members;
  changes = {};
  customFieldsChanged = false;
  constructor(data){
    this.kind = RocketChatAssociationModel.ROOM;
    this.room = data || {
      customFields: {}
    };
    this.members = [];
  }
  setData(data) {
    delete data.id;
    this.room = data;
    this.changes = structuredClone(this.room);
    return this;
  }
  setDisplayName(name) {
    this.room.displayName = name;
    this.changes.displayName = name;
    return this;
  }
  getDisplayName() {
    return this.room.displayName;
  }
  setSlugifiedName(name) {
    this.room.slugifiedName = name;
    this.changes.slugifiedName = name;
    return this;
  }
  getSlugifiedName() {
    return this.room.slugifiedName;
  }
  setType(type) {
    this.room.type = type;
    this.changes.type = type;
    return this;
  }
  getType() {
    return this.room.type;
  }
  setCreator(creator) {
    this.room.creator = creator;
    this.changes.creator = creator;
    return this;
  }
  getCreator() {
    return this.room.creator;
  }
  /**
	 * @deprecated
	 */ addUsername(username) {
    this.addMemberToBeAddedByUsername(username);
    return this;
  }
  /**
	 * @deprecated
	 */ setUsernames(usernames) {
    this.setMembersToBeAddedByUsernames(usernames);
    return this;
  }
  /**
	 * @deprecated
	 */ getUsernames() {
    const usernames = this.getMembersToBeAddedUsernames();
    if (usernames && usernames.length > 0) {
      return usernames;
    }
    return this.room.usernames || [];
  }
  addMemberToBeAddedByUsername(username) {
    this.members.push(username);
    return this;
  }
  setMembersToBeAddedByUsernames(usernames) {
    this.members = usernames;
    return this;
  }
  getMembersToBeAddedUsernames() {
    return this.members;
  }
  setDefault(isDefault) {
    this.room.isDefault = isDefault;
    this.changes.isDefault = isDefault;
    return this;
  }
  getIsDefault() {
    return this.room.isDefault;
  }
  setReadOnly(isReadOnly) {
    this.room.isReadOnly = isReadOnly;
    this.changes.isReadOnly = isReadOnly;
    return this;
  }
  getIsReadOnly() {
    return this.room.isReadOnly;
  }
  setDisplayingOfSystemMessages(displaySystemMessages) {
    this.room.displaySystemMessages = displaySystemMessages;
    this.changes.displaySystemMessages = displaySystemMessages;
    return this;
  }
  getDisplayingOfSystemMessages() {
    return this.room.displaySystemMessages;
  }
  addCustomField(key, value) {
    if (typeof this.room.customFields !== 'object') {
      this.room.customFields = {};
    }
    this.room.customFields[key] = value;
    this.customFieldsChanged = true;
    return this;
  }
  setCustomFields(fields) {
    this.room.customFields = fields;
    this.customFieldsChanged = true;
    return this;
  }
  getCustomFields() {
    return this.room.customFields;
  }
  getUserIds() {
    return this.room.userIds;
  }
  getRoom() {
    return this.room;
  }
  getChanges() {
    const changes = structuredClone(this.changes);
    if (this.customFieldsChanged) {
      changes.customFields = structuredClone(this.room.customFields);
    }
    return changes;
  }
}
//# sourceMappingURL=data:application/json;base64,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