import { MessageBuilder } from './MessageBuilder.ts';
import { require } from '../../../lib/require.ts';
const { RocketChatAssociationModel } = require('@rocket.chat/apps-engine/definition/metadata/RocketChatAssociations.js');
const { RoomType } = require('@rocket.chat/apps-engine/definition/rooms/RoomType.js');
export class LivechatMessageBuilder {
  kind;
  msg;
  constructor(message){
    this.kind = RocketChatAssociationModel.LIVECHAT_MESSAGE;
    this.msg = message || {};
  }
  setData(data) {
    delete data.id;
    this.msg = data;
    return this;
  }
  setRoom(room) {
    this.msg.room = room;
    return this;
  }
  getRoom() {
    return this.msg.room;
  }
  setSender(sender) {
    this.msg.sender = sender;
    delete this.msg.visitor;
    return this;
  }
  getSender() {
    return this.msg.sender;
  }
  setText(text) {
    this.msg.text = text;
    return this;
  }
  getText() {
    return this.msg.text;
  }
  setEmojiAvatar(emoji) {
    this.msg.emoji = emoji;
    return this;
  }
  getEmojiAvatar() {
    return this.msg.emoji;
  }
  setAvatarUrl(avatarUrl) {
    this.msg.avatarUrl = avatarUrl;
    return this;
  }
  getAvatarUrl() {
    return this.msg.avatarUrl;
  }
  setUsernameAlias(alias) {
    this.msg.alias = alias;
    return this;
  }
  getUsernameAlias() {
    return this.msg.alias;
  }
  addAttachment(attachment) {
    if (!this.msg.attachments) {
      this.msg.attachments = [];
    }
    this.msg.attachments.push(attachment);
    return this;
  }
  setAttachments(attachments) {
    this.msg.attachments = attachments;
    return this;
  }
  getAttachments() {
    return this.msg.attachments;
  }
  replaceAttachment(position, attachment) {
    if (!this.msg.attachments) {
      this.msg.attachments = [];
    }
    if (!this.msg.attachments[position]) {
      throw new Error(`No attachment found at the index of "${position}" to replace.`);
    }
    this.msg.attachments[position] = attachment;
    return this;
  }
  removeAttachment(position) {
    if (!this.msg.attachments) {
      this.msg.attachments = [];
    }
    if (!this.msg.attachments[position]) {
      throw new Error(`No attachment found at the index of "${position}" to remove.`);
    }
    this.msg.attachments.splice(position, 1);
    return this;
  }
  setEditor(user) {
    this.msg.editor = user;
    return this;
  }
  getEditor() {
    return this.msg.editor;
  }
  setGroupable(groupable) {
    this.msg.groupable = groupable;
    return this;
  }
  getGroupable() {
    return this.msg.groupable;
  }
  setParseUrls(parseUrls) {
    this.msg.parseUrls = parseUrls;
    return this;
  }
  getParseUrls() {
    return this.msg.parseUrls;
  }
  setToken(token) {
    this.msg.token = token;
    return this;
  }
  getToken() {
    return this.msg.token;
  }
  setVisitor(visitor) {
    this.msg.visitor = visitor;
    delete this.msg.sender;
    return this;
  }
  getVisitor() {
    return this.msg.visitor;
  }
  getMessage() {
    if (!this.msg.room) {
      throw new Error('The "room" property is required.');
    }
    if (this.msg.room.type !== RoomType.LIVE_CHAT) {
      throw new Error('The room is not a Livechat room');
    }
    return this.msg;
  }
  getMessageBuilder() {
    return new MessageBuilder(this.msg);
  }
}
//# sourceMappingURL=data:application/json;base64,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