import { RoomBuilder } from './RoomBuilder.ts';
import { require } from '../../../lib/require.ts';
const { RocketChatAssociationModel } = require('@rocket.chat/apps-engine/definition/metadata/RocketChatAssociations.js');
const { RoomType } = require('@rocket.chat/apps-engine/definition/rooms/RoomType.js');
export class DiscussionBuilder extends RoomBuilder {
  kind;
  reply;
  parentMessage;
  constructor(data){
    super(data);
    this.kind = RocketChatAssociationModel.DISCUSSION;
    this.room.type = RoomType.PRIVATE_GROUP;
  }
  setParentRoom(parentRoom) {
    this.room.parentRoom = parentRoom;
    return this;
  }
  getParentRoom() {
    return this.room.parentRoom;
  }
  setReply(reply) {
    this.reply = reply;
    return this;
  }
  getReply() {
    return this.reply;
  }
  setParentMessage(parentMessage) {
    this.parentMessage = parentMessage;
    return this;
  }
  getParentMessage() {
    return this.parentMessage;
  }
}
//# sourceMappingURL=data:application/json;base64,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