import { v1 as uuid } from 'uuid';
import { AppObjectRegistry } from '../../../AppObjectRegistry.ts';
import { require } from '../../../lib/require.ts';
const { BlockType } = require('@rocket.chat/apps-engine/definition/uikit/blocks/Blocks.js');
const { BlockElementType } = require('@rocket.chat/apps-engine/definition/uikit/blocks/Elements.js');
const { TextObjectType } = require('@rocket.chat/apps-engine/definition/uikit/blocks/Objects.js');
/**
 * @deprecated please prefer the rocket.chat/ui-kit components
 */ export class BlockBuilder {
  blocks;
  appId;
  constructor(){
    this.blocks = [];
    this.appId = String(AppObjectRegistry.get('id'));
  }
  addSectionBlock(block) {
    this.addBlock({
      type: BlockType.SECTION,
      ...block
    });
    return this;
  }
  addImageBlock(block) {
    this.addBlock({
      type: BlockType.IMAGE,
      ...block
    });
    return this;
  }
  addDividerBlock() {
    this.addBlock({
      type: BlockType.DIVIDER
    });
    return this;
  }
  addActionsBlock(block) {
    this.addBlock({
      type: BlockType.ACTIONS,
      ...block
    });
    return this;
  }
  addContextBlock(block) {
    this.addBlock({
      type: BlockType.CONTEXT,
      ...block
    });
    return this;
  }
  addInputBlock(block) {
    this.addBlock({
      type: BlockType.INPUT,
      ...block
    });
    return this;
  }
  addConditionalBlock(innerBlocks, condition) {
    const render = innerBlocks instanceof BlockBuilder ? innerBlocks.getBlocks() : innerBlocks;
    this.addBlock({
      type: BlockType.CONDITIONAL,
      render,
      when: condition
    });
    return this;
  }
  getBlocks() {
    return this.blocks;
  }
  newPlainTextObject(text, emoji = false) {
    return {
      type: TextObjectType.PLAINTEXT,
      text,
      emoji
    };
  }
  newMarkdownTextObject(text) {
    return {
      type: TextObjectType.MARKDOWN,
      text
    };
  }
  newButtonElement(info) {
    return this.newInteractiveElement({
      type: BlockElementType.BUTTON,
      ...info
    });
  }
  newImageElement(info) {
    return {
      type: BlockElementType.IMAGE,
      ...info
    };
  }
  newOverflowMenuElement(info) {
    return this.newInteractiveElement({
      type: BlockElementType.OVERFLOW_MENU,
      ...info
    });
  }
  newPlainTextInputElement(info) {
    return this.newInputElement({
      type: BlockElementType.PLAIN_TEXT_INPUT,
      ...info
    });
  }
  newStaticSelectElement(info) {
    return this.newSelectElement({
      type: BlockElementType.STATIC_SELECT,
      ...info
    });
  }
  newMultiStaticElement(info) {
    return this.newSelectElement({
      type: BlockElementType.MULTI_STATIC_SELECT,
      ...info
    });
  }
  newInteractiveElement(element) {
    if (!element.actionId) {
      element.actionId = this.generateActionId();
    }
    return element;
  }
  newInputElement(element) {
    if (!element.actionId) {
      element.actionId = this.generateActionId();
    }
    return element;
  }
  newSelectElement(element) {
    if (!element.actionId) {
      element.actionId = this.generateActionId();
    }
    return element;
  }
  addBlock(block) {
    if (!block.blockId) {
      block.blockId = this.generateBlockId();
    }
    block.appId = this.appId;
    this.blocks.push(block);
  }
  generateBlockId() {
    return uuid();
  }
  generateActionId() {
    return uuid();
  }
}
//# sourceMappingURL=data:application/json;base64,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