import { JsonRpcError } from 'jsonrpc-lite';
import { require } from '../../lib/require.ts';
import { AppObjectRegistry } from '../../AppObjectRegistry.ts';
import { AppAccessorsInstance } from '../../lib/accessors/mod.ts';
export const uikitInteractions = [
  'executeBlockActionHandler',
  'executeViewSubmitHandler',
  'executeViewClosedHandler',
  'executeActionButtonHandler',
  'executeLivechatBlockActionHandler'
];
export const { UIKitBlockInteractionContext, UIKitViewSubmitInteractionContext, UIKitViewCloseInteractionContext, UIKitActionButtonInteractionContext } = require('@rocket.chat/apps-engine/definition/uikit/UIKitInteractionContext.js');
export const { UIKitLivechatBlockInteractionContext } = require('@rocket.chat/apps-engine/definition/uikit/livechat/UIKitLivechatInteractionContext.js');
export default async function handleUIKitInteraction(method, params) {
  if (!uikitInteractions.includes(method)) {
    return JsonRpcError.methodNotFound(null);
  }
  if (!Array.isArray(params)) {
    return JsonRpcError.invalidParams(null);
  }
  const app = AppObjectRegistry.get('app');
  const interactionHandler = app?.[method];
  if (!app || typeof interactionHandler !== 'function') {
    return JsonRpcError.methodNotFound({
      message: `App does not implement method "${method}"`
    });
  }
  const [payload] = params;
  if (!payload) {
    return JsonRpcError.invalidParams(null);
  }
  let context;
  switch(method){
    case 'executeBlockActionHandler':
      context = new UIKitBlockInteractionContext(payload);
      break;
    case 'executeViewSubmitHandler':
      context = new UIKitViewSubmitInteractionContext(payload);
      break;
    case 'executeViewClosedHandler':
      context = new UIKitViewCloseInteractionContext(payload);
      break;
    case 'executeActionButtonHandler':
      context = new UIKitActionButtonInteractionContext(payload);
      break;
    case 'executeLivechatBlockActionHandler':
      context = new UIKitLivechatBlockInteractionContext(payload);
      break;
  }
  try {
    return await interactionHandler.call(app, context, AppAccessorsInstance.getReader(), AppAccessorsInstance.getHttp(), AppAccessorsInstance.getPersistence(), AppAccessorsInstance.getModifier());
  } catch (e) {
    return JsonRpcError.internalError({
      message: e.message
    });
  }
}
//# sourceMappingURL=data:application/json;base64,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