import { JsonRpcError } from 'jsonrpc-lite';
import { AppObjectRegistry } from '../AppObjectRegistry.ts';
import { AppAccessorsInstance } from '../lib/accessors/mod.ts';
export default async function handleScheduler(method, params) {
  const [, processorId] = method.split(':');
  if (!Array.isArray(params)) {
    return JsonRpcError.invalidParams({
      message: 'Invalid params'
    });
  }
  const [context] = params;
  const app = AppObjectRegistry.get('app');
  if (!app) {
    return JsonRpcError.internalError({
      message: 'App not found'
    });
  }
  // AppSchedulerManager will append the appId to the processor name to avoid conflicts
  const processor = AppObjectRegistry.get(`scheduler:${processorId}`);
  if (!processor) {
    return JsonRpcError.methodNotFound({
      message: `Could not find processor for method ${method}`
    });
  }
  app.getLogger().debug(`Job processor ${processor.id} is being executed...`);
  try {
    await processor.processor(context, AppAccessorsInstance.getReader(), AppAccessorsInstance.getModifier(), AppAccessorsInstance.getHttp(), AppAccessorsInstance.getPersistence());
    app.getLogger().debug(`Job processor ${processor.id} was successfully executed`);
    return null;
  } catch (e) {
    app.getLogger().error(e);
    app.getLogger().error(`Job processor ${processor.id} was unsuccessful`);
    return JsonRpcError.internalError({
      message: e.message
    });
  }
}
//# sourceMappingURL=data:application/json;base64,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