import { JsonRpcError } from 'jsonrpc-lite';
import { AppObjectRegistry } from '../AppObjectRegistry.ts';
import { AppAccessorsInstance } from '../lib/accessors/mod.ts';
export default async function outboundMessageHandler(call, params) {
  const [, providerName, methodName] = call.split(':');
  const provider = AppObjectRegistry.get(`outboundCommunication:${providerName}`);
  if (!provider) {
    return new JsonRpcError('error-invalid-provider', -32000);
  }
  const method = provider[methodName];
  const logger = AppObjectRegistry.get('logger');
  const args = params ?? [];
  try {
    logger?.debug(`Executing ${methodName} on outbound communication provider...`);
    // deno-lint-ignore ban-types
    return await method.apply(provider, [
      ...args,
      AppAccessorsInstance.getReader(),
      AppAccessorsInstance.getModifier(),
      AppAccessorsInstance.getHttp(),
      AppAccessorsInstance.getPersistence()
    ]);
  } catch (e) {
    return new JsonRpcError(e.message, -32000);
  }
}
//# sourceMappingURL=data:application/json;base64,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