import { AppObjectRegistry } from '../../AppObjectRegistry.ts';
import { require } from '../../lib/require.ts';
const { AppStatus } = require('@rocket.chat/apps-engine/definition/AppStatus.js');
export default async function handleSetStatus(params) {
  if (!Array.isArray(params) || !Object.values(AppStatus).includes(params[0])) {
    throw new Error('Invalid params', {
      cause: 'invalid_param_type'
    });
  }
  const [status] = params;
  const app = AppObjectRegistry.get('app');
  if (!app || typeof app['setStatus'] !== 'function') {
    throw new Error('App must contain a setStatus function', {
      cause: 'invalid_app'
    });
  }
  await app['setStatus'](status);
  return null;
}
//# sourceMappingURL=data:application/json;base64,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