import { AppObjectRegistry } from '../../AppObjectRegistry.ts';
import { AppAccessorsInstance } from '../../lib/accessors/mod.ts';
export default async function handleOnUninstall(params) {
  const app = AppObjectRegistry.get('app');
  if (typeof app?.onUninstall !== 'function') {
    throw new Error('App must contain an onUninstall function', {
      cause: 'invalid_app'
    });
  }
  if (!Array.isArray(params)) {
    throw new Error('Invalid params', {
      cause: 'invalid_param_type'
    });
  }
  const [context] = params;
  await app.onUninstall(context, AppAccessorsInstance.getReader(), AppAccessorsInstance.getHttp(), AppAccessorsInstance.getPersistence(), AppAccessorsInstance.getModifier());
  return true;
}
//# sourceMappingURL=data:application/json;base64,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