import { AppObjectRegistry } from '../../AppObjectRegistry.ts';
import { AppAccessorsInstance } from '../../lib/accessors/mod.ts';
export default async function handleOnSettingUpdated(params) {
  const app = AppObjectRegistry.get('app');
  if (typeof app?.onSettingUpdated !== 'function') {
    throw new Error('App must contain an onSettingUpdated function', {
      cause: 'invalid_app'
    });
  }
  if (!Array.isArray(params)) {
    throw new Error('Invalid params', {
      cause: 'invalid_param_type'
    });
  }
  const [setting] = params;
  await app.onSettingUpdated(setting, AppAccessorsInstance.getConfigurationModify(), AppAccessorsInstance.getReader(), AppAccessorsInstance.getHttp());
  return true;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImZpbGU6Ly8vaG9tZS9ydW5uZXIvd29yay9Sb2NrZXQuQ2hhdC9Sb2NrZXQuQ2hhdC9wYWNrYWdlcy9hcHBzLWVuZ2luZS9kZW5vLXJ1bnRpbWUvaGFuZGxlcnMvYXBwL2hhbmRsZU9uU2V0dGluZ1VwZGF0ZWQudHMiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHR5cGUgeyBBcHAgfSBmcm9tICdAcm9ja2V0LmNoYXQvYXBwcy1lbmdpbmUvZGVmaW5pdGlvbi9BcHAudHMnO1xuXG5pbXBvcnQgeyBBcHBPYmplY3RSZWdpc3RyeSB9IGZyb20gJy4uLy4uL0FwcE9iamVjdFJlZ2lzdHJ5LnRzJztcbmltcG9ydCB7IEFwcEFjY2Vzc29yc0luc3RhbmNlIH0gZnJvbSAnLi4vLi4vbGliL2FjY2Vzc29ycy9tb2QudHMnO1xuXG5leHBvcnQgZGVmYXVsdCBhc3luYyBmdW5jdGlvbiBoYW5kbGVPblNldHRpbmdVcGRhdGVkKHBhcmFtczogdW5rbm93bik6IFByb21pc2U8Ym9vbGVhbj4ge1xuXHRjb25zdCBhcHAgPSBBcHBPYmplY3RSZWdpc3RyeS5nZXQ8QXBwPignYXBwJyk7XG5cblx0aWYgKHR5cGVvZiBhcHA/Lm9uU2V0dGluZ1VwZGF0ZWQgIT09ICdmdW5jdGlvbicpIHtcblx0XHR0aHJvdyBuZXcgRXJyb3IoJ0FwcCBtdXN0IGNvbnRhaW4gYW4gb25TZXR0aW5nVXBkYXRlZCBmdW5jdGlvbicsIHtcblx0XHRcdGNhdXNlOiAnaW52YWxpZF9hcHAnLFxuXHRcdH0pO1xuXHR9XG5cblx0aWYgKCFBcnJheS5pc0FycmF5KHBhcmFtcykpIHtcblx0XHR0aHJvdyBuZXcgRXJyb3IoJ0ludmFsaWQgcGFyYW1zJywgeyBjYXVzZTogJ2ludmFsaWRfcGFyYW1fdHlwZScgfSk7XG5cdH1cblxuXHRjb25zdCBbc2V0dGluZ10gPSBwYXJhbXMgYXMgW1JlY29yZDxzdHJpbmcsIHVua25vd24+XTtcblxuXHRhd2FpdCBhcHAub25TZXR0aW5nVXBkYXRlZChzZXR0aW5nLCBBcHBBY2Nlc3NvcnNJbnN0YW5jZS5nZXRDb25maWd1cmF0aW9uTW9kaWZ5KCksIEFwcEFjY2Vzc29yc0luc3RhbmNlLmdldFJlYWRlcigpLCBBcHBBY2Nlc3NvcnNJbnN0YW5jZS5nZXRIdHRwKCkpO1xuXG5cdHJldHVybiB0cnVlO1xufVxuIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUVBLFNBQVMsaUJBQWlCLFFBQVEsNkJBQTZCO0FBQy9ELFNBQVMsb0JBQW9CLFFBQVEsNkJBQTZCO0FBRWxFLGVBQWUsZUFBZSx1QkFBdUIsTUFBZTtFQUNuRSxNQUFNLE1BQU0sa0JBQWtCLEdBQUcsQ0FBTTtFQUV2QyxJQUFJLE9BQU8sS0FBSyxxQkFBcUIsWUFBWTtJQUNoRCxNQUFNLElBQUksTUFBTSxpREFBaUQ7TUFDaEUsT0FBTztJQUNSO0VBQ0Q7RUFFQSxJQUFJLENBQUMsTUFBTSxPQUFPLENBQUMsU0FBUztJQUMzQixNQUFNLElBQUksTUFBTSxrQkFBa0I7TUFBRSxPQUFPO0lBQXFCO0VBQ2pFO0VBRUEsTUFBTSxDQUFDLFFBQVEsR0FBRztFQUVsQixNQUFNLElBQUksZ0JBQWdCLENBQUMsU0FBUyxxQkFBcUIsc0JBQXNCLElBQUkscUJBQXFCLFNBQVMsSUFBSSxxQkFBcUIsT0FBTztFQUVqSixPQUFPO0FBQ1IifQ==