import { AppObjectRegistry } from '../../AppObjectRegistry.ts';
import { AppAccessorsInstance } from '../../lib/accessors/mod.ts';
export default function handleOnPreSettingUpdate(params) {
  const app = AppObjectRegistry.get('app');
  if (typeof app?.onPreSettingUpdate !== 'function') {
    throw new Error('App must contain an onPreSettingUpdate function', {
      cause: 'invalid_app'
    });
  }
  if (!Array.isArray(params)) {
    throw new Error('Invalid params', {
      cause: 'invalid_param_type'
    });
  }
  const [setting] = params;
  return app.onPreSettingUpdate(setting, AppAccessorsInstance.getConfigurationModify(), AppAccessorsInstance.getReader(), AppAccessorsInstance.getHttp());
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImZpbGU6Ly8vaG9tZS9ydW5uZXIvd29yay9Sb2NrZXQuQ2hhdC9Sb2NrZXQuQ2hhdC9wYWNrYWdlcy9hcHBzLWVuZ2luZS9kZW5vLXJ1bnRpbWUvaGFuZGxlcnMvYXBwL2hhbmRsZU9uUHJlU2V0dGluZ1VwZGF0ZS50cyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgdHlwZSB7IEFwcCB9IGZyb20gJ0Byb2NrZXQuY2hhdC9hcHBzLWVuZ2luZS9kZWZpbml0aW9uL0FwcC50cyc7XG5cbmltcG9ydCB7IEFwcE9iamVjdFJlZ2lzdHJ5IH0gZnJvbSAnLi4vLi4vQXBwT2JqZWN0UmVnaXN0cnkudHMnO1xuaW1wb3J0IHsgQXBwQWNjZXNzb3JzSW5zdGFuY2UgfSBmcm9tICcuLi8uLi9saWIvYWNjZXNzb3JzL21vZC50cyc7XG5cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIGhhbmRsZU9uUHJlU2V0dGluZ1VwZGF0ZShwYXJhbXM6IHVua25vd24pOiBQcm9taXNlPG9iamVjdD4ge1xuXHRjb25zdCBhcHAgPSBBcHBPYmplY3RSZWdpc3RyeS5nZXQ8QXBwPignYXBwJyk7XG5cblx0aWYgKHR5cGVvZiBhcHA/Lm9uUHJlU2V0dGluZ1VwZGF0ZSAhPT0gJ2Z1bmN0aW9uJykge1xuXHRcdHRocm93IG5ldyBFcnJvcignQXBwIG11c3QgY29udGFpbiBhbiBvblByZVNldHRpbmdVcGRhdGUgZnVuY3Rpb24nLCB7XG5cdFx0XHRjYXVzZTogJ2ludmFsaWRfYXBwJyxcblx0XHR9KTtcblx0fVxuXG5cdGlmICghQXJyYXkuaXNBcnJheShwYXJhbXMpKSB7XG5cdFx0dGhyb3cgbmV3IEVycm9yKCdJbnZhbGlkIHBhcmFtcycsIHsgY2F1c2U6ICdpbnZhbGlkX3BhcmFtX3R5cGUnIH0pO1xuXHR9XG5cblx0Y29uc3QgW3NldHRpbmddID0gcGFyYW1zIGFzIFtSZWNvcmQ8c3RyaW5nLCB1bmtub3duPl07XG5cblx0cmV0dXJuIGFwcC5vblByZVNldHRpbmdVcGRhdGUoc2V0dGluZywgQXBwQWNjZXNzb3JzSW5zdGFuY2UuZ2V0Q29uZmlndXJhdGlvbk1vZGlmeSgpLCBBcHBBY2Nlc3NvcnNJbnN0YW5jZS5nZXRSZWFkZXIoKSwgQXBwQWNjZXNzb3JzSW5zdGFuY2UuZ2V0SHR0cCgpKTtcbn1cbiJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFFQSxTQUFTLGlCQUFpQixRQUFRLDZCQUE2QjtBQUMvRCxTQUFTLG9CQUFvQixRQUFRLDZCQUE2QjtBQUVsRSxlQUFlLFNBQVMseUJBQXlCLE1BQWU7RUFDL0QsTUFBTSxNQUFNLGtCQUFrQixHQUFHLENBQU07RUFFdkMsSUFBSSxPQUFPLEtBQUssdUJBQXVCLFlBQVk7SUFDbEQsTUFBTSxJQUFJLE1BQU0sbURBQW1EO01BQ2xFLE9BQU87SUFDUjtFQUNEO0VBRUEsSUFBSSxDQUFDLE1BQU0sT0FBTyxDQUFDLFNBQVM7SUFDM0IsTUFBTSxJQUFJLE1BQU0sa0JBQWtCO01BQUUsT0FBTztJQUFxQjtFQUNqRTtFQUVBLE1BQU0sQ0FBQyxRQUFRLEdBQUc7RUFFbEIsT0FBTyxJQUFJLGtCQUFrQixDQUFDLFNBQVMscUJBQXFCLHNCQUFzQixJQUFJLHFCQUFxQixTQUFTLElBQUkscUJBQXFCLE9BQU87QUFDckoifQ==