import { AppObjectRegistry } from '../../AppObjectRegistry.ts';
import { AppAccessorsInstance } from '../../lib/accessors/mod.ts';
export default async function handleOnInstall(params) {
  const app = AppObjectRegistry.get('app');
  if (typeof app?.onInstall !== 'function') {
    throw new Error('App must contain an onInstall function', {
      cause: 'invalid_app'
    });
  }
  if (!Array.isArray(params)) {
    throw new Error('Invalid params', {
      cause: 'invalid_param_type'
    });
  }
  const [context] = params;
  await app.onInstall(context, AppAccessorsInstance.getReader(), AppAccessorsInstance.getHttp(), AppAccessorsInstance.getPersistence(), AppAccessorsInstance.getModifier());
  return true;
}
//# sourceMappingURL=data:application/json;base64,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