import { AppObjectRegistry } from '../../AppObjectRegistry.ts';
import { AppAccessorsInstance } from '../../lib/accessors/mod.ts';
export default async function handleInitialize() {
  const app = AppObjectRegistry.get('app');
  if (typeof app?.initialize !== 'function') {
    throw new Error('App must contain an initialize function', {
      cause: 'invalid_app'
    });
  }
  await app.initialize(AppAccessorsInstance.getConfigurationExtend(), AppAccessorsInstance.getEnvironmentRead());
  return true;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImZpbGU6Ly8vaG9tZS9ydW5uZXIvd29yay9Sb2NrZXQuQ2hhdC9Sb2NrZXQuQ2hhdC9wYWNrYWdlcy9hcHBzLWVuZ2luZS9kZW5vLXJ1bnRpbWUvaGFuZGxlcnMvYXBwL2hhbmRsZUluaXRpYWxpemUudHMiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHR5cGUgeyBBcHAgfSBmcm9tICdAcm9ja2V0LmNoYXQvYXBwcy1lbmdpbmUvZGVmaW5pdGlvbi9BcHAudHMnO1xuXG5pbXBvcnQgeyBBcHBPYmplY3RSZWdpc3RyeSB9IGZyb20gJy4uLy4uL0FwcE9iamVjdFJlZ2lzdHJ5LnRzJztcbmltcG9ydCB7IEFwcEFjY2Vzc29yc0luc3RhbmNlIH0gZnJvbSAnLi4vLi4vbGliL2FjY2Vzc29ycy9tb2QudHMnO1xuXG5leHBvcnQgZGVmYXVsdCBhc3luYyBmdW5jdGlvbiBoYW5kbGVJbml0aWFsaXplKCk6IFByb21pc2U8Ym9vbGVhbj4ge1xuXHRjb25zdCBhcHAgPSBBcHBPYmplY3RSZWdpc3RyeS5nZXQ8QXBwPignYXBwJyk7XG5cblx0aWYgKHR5cGVvZiBhcHA/LmluaXRpYWxpemUgIT09ICdmdW5jdGlvbicpIHtcblx0XHR0aHJvdyBuZXcgRXJyb3IoJ0FwcCBtdXN0IGNvbnRhaW4gYW4gaW5pdGlhbGl6ZSBmdW5jdGlvbicsIHtcblx0XHRcdGNhdXNlOiAnaW52YWxpZF9hcHAnLFxuXHRcdH0pO1xuXHR9XG5cblx0YXdhaXQgYXBwLmluaXRpYWxpemUoQXBwQWNjZXNzb3JzSW5zdGFuY2UuZ2V0Q29uZmlndXJhdGlvbkV4dGVuZCgpLCBBcHBBY2Nlc3NvcnNJbnN0YW5jZS5nZXRFbnZpcm9ubWVudFJlYWQoKSk7XG5cblx0cmV0dXJuIHRydWU7XG59XG4iXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBRUEsU0FBUyxpQkFBaUIsUUFBUSw2QkFBNkI7QUFDL0QsU0FBUyxvQkFBb0IsUUFBUSw2QkFBNkI7QUFFbEUsZUFBZSxlQUFlO0VBQzdCLE1BQU0sTUFBTSxrQkFBa0IsR0FBRyxDQUFNO0VBRXZDLElBQUksT0FBTyxLQUFLLGVBQWUsWUFBWTtJQUMxQyxNQUFNLElBQUksTUFBTSwyQ0FBMkM7TUFDMUQsT0FBTztJQUNSO0VBQ0Q7RUFFQSxNQUFNLElBQUksVUFBVSxDQUFDLHFCQUFxQixzQkFBc0IsSUFBSSxxQkFBcUIsa0JBQWtCO0VBRTNHLE9BQU87QUFDUiJ9