import {createFocusManager as $7CEvq$createFocusManager, getFocusableTreeWalker as $7CEvq$getFocusableTreeWalker} from "@react-aria/focus";
import {mergeProps as $7CEvq$mergeProps} from "@react-aria/utils";
import {useLocale as $7CEvq$useLocale} from "@react-aria/i18n";
import {useMemo as $7CEvq$useMemo} from "react";
import {usePress as $7CEvq$usePress} from "@react-aria/interactions";






function $3dfb0f96be0d6a08$export$4a931266a3838b86(state, ref, disableArrowNavigation) {
    let { direction: direction } = (0, $7CEvq$useLocale)();
    let focusManager = (0, $7CEvq$useMemo)(()=>(0, $7CEvq$createFocusManager)(ref), [
        ref
    ]);
    // Open the popover on alt + arrow down
    let onKeyDown = (e)=>{
        if (!e.currentTarget.contains(e.target)) return;
        if (e.altKey && (e.key === 'ArrowDown' || e.key === 'ArrowUp') && 'setOpen' in state) {
            e.preventDefault();
            e.stopPropagation();
            state.setOpen(true);
        }
        if (disableArrowNavigation) return;
        switch(e.key){
            case 'ArrowLeft':
                e.preventDefault();
                e.stopPropagation();
                if (direction === 'rtl') focusManager.focusNext();
                else focusManager.focusPrevious();
                break;
            case 'ArrowRight':
                e.preventDefault();
                e.stopPropagation();
                if (direction === 'rtl') focusManager.focusPrevious();
                else focusManager.focusNext();
                break;
        }
    };
    // Focus the first placeholder segment from the end on mouse down/touch up in the field.
    let focusLast = ()=>{
        var _window_event;
        if (!ref.current) return;
        // Try to find the segment prior to the element that was clicked on.
        let target = (_window_event = window.event) === null || _window_event === void 0 ? void 0 : _window_event.target;
        let walker = (0, $7CEvq$getFocusableTreeWalker)(ref.current, {
            tabbable: true
        });
        if (target) {
            walker.currentNode = target;
            target = walker.previousNode();
        }
        // If no target found, find the last element from the end.
        if (!target) {
            let last;
            do {
                last = walker.lastChild();
                if (last) target = last;
            }while (last);
        }
        // Now go backwards until we find an element that is not a placeholder.
        while(target === null || target === void 0 ? void 0 : target.hasAttribute('data-placeholder')){
            let prev = walker.previousNode();
            if (prev && prev.hasAttribute('data-placeholder')) target = prev;
            else break;
        }
        if (target) target.focus();
    };
    let { pressProps: pressProps } = (0, $7CEvq$usePress)({
        preventFocusOnPress: true,
        allowTextSelectionOnPress: true,
        onPressStart (e) {
            if (e.pointerType === 'mouse') focusLast();
        },
        onPress (e) {
            if (e.pointerType !== 'mouse') focusLast();
        }
    });
    return (0, $7CEvq$mergeProps)(pressProps, {
        onKeyDown: onKeyDown
    });
}


export {$3dfb0f96be0d6a08$export$4a931266a3838b86 as useDatePickerGroup};
//# sourceMappingURL=useDatePickerGroup.module.js.map
